/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.util;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sys.InterfaceLogDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SAASResultDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.InterfaceLog;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.xiaoleilu.hutool.http.HttpUtil;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BKTInterfaceUtil {
    private static Logger logger = LoggerFactory.getLogger(BKTInterfaceUtil.class);
    @Autowired
    private InterfaceLogDao interfaceLogDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public AjaxResult callInterface(String url, Object paramObj) {
        Map paramMap = BeanUtil.beanToMap((Object)paramObj);
        return this.callInterface(url, paramMap);
    }

    public AjaxResult callInterface(String url, Map<String, Object> paramMap) {
        String msg = "";
        Boolean result = true;
        Object data = null;
        User currentUser = this.arsUtil.getCurrentUser();
        url = this.configUtils.bkt_data_host + url;
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(Boolean.valueOf(true));
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));
        if (currentUser != null) {
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            String resultStr = HttpUtil.post((String)url, paramMap);
            interfaceLog.setResult(resultStr);
            SAASResultDto resultDto = (SAASResultDto)JSONObject.parseObject((String)resultStr, SAASResultDto.class);
            if (resultDto != null && StringUtil.isNotEmpty((String)resultDto.getRetType())) {
                String retType = resultDto.getRetType();
                if (Constants.BTK_IS_SUCCESS.equals(retType)) {
                    data = resultDto.getData();
                    logger.info("\u767e\u4fdd\u76fe\u4e0e\u767e\u8bfe\u5802\u540c\u6b65\u6210\u529f");
                } else {
                    result = false;
                    msg = resultDto.getMsg();
                    logger.error(resultStr);
                    logger.info("\u767e\u4fdd\u76fe\u4e0e\u767e\u8bfe\u5802\u540c\u6b65\u5931\u8d25");
                }
            } else {
                result = false;
                msg = "\u6ca1\u6709\u8fd4\u56de\u7ed3\u679c";
                logger.info("\u767e\u4fdd\u76fe\u4e0e\u767e\u8bfe\u5802\u540c\u6b65\u5931\u8d25,\u6ca1\u6709\u8fd4\u56de\u7ed3\u679c");
            }
        }
        catch (Exception e) {
            result = false;
            logger.error(e.getMessage(), (Throwable)e);
            msg = e.getMessage();
            interfaceLog.setResult(e.getMessage());
        }
        interfaceLog.setUpdateTime(new Date());
        interfaceLog.setSuccessful(result.booleanValue());
        new Thread(() -> this.interfaceLogDao.insert(interfaceLog)).start();
        if (StringUtil.isNotEmpty((String)msg)) {
            msg = "\u767e\u4fdd\u76fe\u4e0e\u767e\u8bfe\u5802\u540c\u6b65\u5931\u8d25:" + msg;
        }
        return new AjaxResult(result.booleanValue(), msg, data);
    }

    public static void main(String[] args) {
        String url = "http://outbjbbd.test.baibaodun.cn/ars-rest/comTask/contract/save.json";
        String contracts = "[{\"comContractId\":638318060121358336,\"comTaskId\":636983286630973440,\"createBy\":634333489453334528,\"createTime\":1572229567521,\"isDelete\":\"0\",\"updateTime\":1572229567524}]";
        HashedMap paramMap = new HashedMap();
        paramMap.put("sid", "0E44373E153D7C59341D77809D11C17E07FD91598F759F3E79BFA3D9BDB2CCCF7DD089A41E48CD4CADB1F18A76187437EC609C2215764BBA1AF3EF5CE85BAAC2");
        paramMap.put("comTaskId", 636983286630973440L);
        paramMap.put("contracts", contracts);
        String resultStr = HttpUtil.post((String)url, (Map)paramMap);
        System.out.println(resultStr);
    }
}

