/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.sys.RegisterpersonDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.Registerperson;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.sys.RegisterpersonService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Sha1Util;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RegisterpersonServiceImpl
implements RegisterpersonService {
    private static Logger logger = LoggerFactory.getLogger(RegisterpersonServiceImpl.class);
    @Autowired
    private RegisterpersonDao registerpersonDao;
    @Autowired
    private UserService userService;
    @Autowired
    private ArsUtil arsUtil;

    public AjaxResult singleUserRegister(User user) {
        AjaxResult result = new AjaxResult();
        try {
            User dbUser = this.userService.findByUsername(user.getPhone(), String.valueOf(4));
            if (dbUser != null) {
                result.setSuccessful(false);
                result.setMsg("\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c!");
                return result;
            }
            user.setPlatform(Integer.valueOf(4));
            user.setUpdateBy(user.getUsername());
            user.setPassword(Sha1Util.entryptPassword((String)user.getPassword()));
            this.userService.saveOrUpdate(user, String.valueOf(user.getPlatform()));
            Registerperson registerperson = new Registerperson();
            registerperson.setCompanyname(user.getPhone());
            registerperson.setCompanytype("1");
            registerperson.setName(user.getRealname());
            registerperson.setPhone(user.getPhone());
            registerperson.setUserid(user.getId());
            this.saveOrUpdate(registerperson);
            result.setSuccessful(true);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    public AjaxResult SXNWregister(User user) {
        AjaxResult result = new AjaxResult();
        try {
            User dbUser = this.userService.findByUsername(user.getPhone(), String.valueOf(4));
            if (dbUser != null) {
                result.setSuccessful(false);
                result.setMsg("\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c!");
                return result;
            }
            user.setPlatform(Integer.valueOf(4));
            user.setRealname(user.getPhone());
            user.setUpdateBy(user.getUsername());
            user.setPassword(Sha1Util.entryptPassword((String)user.getPassword()));
            this.userService.saveOrUpdate(user, String.valueOf(user.getPlatform()));
            Registerperson registerperson = new Registerperson();
            registerperson.setCompanyname(user.getPhone());
            registerperson.setCompanytype("1");
            registerperson.setName(user.getRealname());
            registerperson.setPhone(user.getPhone());
            registerperson.setUserid(user.getId());
            this.saveOrUpdate(registerperson);
            result.setSuccessful(true);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    public Registerperson findById(long id) {
        return this.registerpersonDao.findById(id);
    }

    public void saveOrUpdate(Registerperson registerperson) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (registerperson.getId() == null) {
            registerperson.setActive(Boolean.valueOf(true));
            registerperson.setCreateTime(new Date());
            registerperson.setUpdateTime(new Date());
            if (currentUser != null) {
                registerperson.setUpdateBy(currentUser.getUsername());
            }
            registerperson.setName(registerperson.getPhone());
            registerperson.setCompanytype("1");
            registerperson.setCompanyname(registerperson.getPhone());
            this.registerpersonDao.save(registerperson);
        } else {
            Registerperson dbRegisterperson = this.registerpersonDao.findById(registerperson.getId().longValue());
            dbRegisterperson.setUpdateTime(new Date());
            if (currentUser != null) {
                dbRegisterperson.setUpdateBy(currentUser.getUsername());
            }
            dbRegisterperson.setUpdateTime(new Date());
            dbRegisterperson.setCompanyname(registerperson.getCompanyname());
            dbRegisterperson.setCardnumber(registerperson.getCardnumber());
            dbRegisterperson.setCompanytype(registerperson.getCompanytype());
            dbRegisterperson.setEmail(registerperson.getEmail());
            dbRegisterperson.setName(registerperson.getName());
            dbRegisterperson.setPhone(registerperson.getPhone());
            dbRegisterperson.setValidatecode(registerperson.getValidatecode());
            this.registerpersonDao.update(dbRegisterperson);
        }
    }

    public AjaxResult register(User user) {
        AjaxResult result = new AjaxResult();
        try {
            User dbUser = this.userService.findByUsername(user.getUsername(), String.valueOf(4));
            if (dbUser != null) {
                result.setSuccessful(false);
                result.setMsg("\u767b\u9646\u7528\u6237\u540d\u5df2\u5b58\u5728!");
                return result;
            }
            dbUser = this.userService.findByUsername(user.getPhone(), String.valueOf(4));
            if (dbUser != null) {
                result.setSuccessful(false);
                result.setMsg("\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c!");
                return result;
            }
            user.setPlatform(Integer.valueOf(4));
            user.setUsername(user.getUsername());
            user.setPhone(user.getPhone());
            user.setUpdateBy(user.getUsername());
            user.setPassword(Sha1Util.entryptPassword((String)user.getPassword()));
            this.userService.saveOrUpdate(user, String.valueOf(user.getPlatform()));
            Registerperson registerperson = new Registerperson();
            registerperson.setCompanyname(user.getPhone());
            registerperson.setCompanytype("1");
            registerperson.setName(user.getPhone());
            registerperson.setPhone(user.getPhone());
            registerperson.setUserid(user.getId());
            this.saveOrUpdate(registerperson);
            result.setSuccessful(true);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }
}

