/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.supervision;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.supervision.CompanyPunishDao;
import com.bcxin.ars.dao.supervision.CompanyPunishDaoAop;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.supervision.CompanyPunishPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.supervision.CompanyPunish;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.supervision.CompanyPunishService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=CompanyPunish.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
@DataSyncOutAnnotation(getClazz=CompanyPunish.class, getImportType=ImportType.BATCH)
public class CompanyPunishServiceImpl
extends BaseService
implements CompanyPunishService {
    @Autowired
    private CompanyPunishDao companyPunishDao;
    @Autowired
    private CompanyPunishDaoAop companyPunishDaoAop;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdWorker idWorker;
    @Autowired
    private ConfigUtils configUtils;

    public int delete(CompanyPunish record) {
        User currentUser = this.arsUtil.getCurrentUser();
        record.setUpdateTime(new Date());
        record.setUpdateBy(currentUser.getUsername());
        return this.companyPunishDaoAop.delete(record);
    }

    public void save(CompanyPunish record) {
        String isInSystem;
        User currentUser = this.arsUtil.getCurrentUser();
        if (record.getId() == null) {
            record.setId(Long.valueOf(this.idWorker.nextId()));
            record.setCreateTime(new Date());
            if (StringUtil.isNotEmpty((String)record.getSignImgPath())) {
                record.setSignImgPath(this.saveBase64Img(record.getSignImgPath()));
            }
        } else {
            CompanyPunish dbRecord = this.companyPunishDao.findById(record.getId());
            BeanUtils.copyPropertiesIgnore((Object)record, (Object)dbRecord, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbRecord, (Object)record, (Boolean)false);
        }
        if (!StringUtils.isEmpty((Object)(isInSystem = record.getIsInSystem())) && isInSystem.equals("2")) {
            String companyNameDefine = record.getCompanyNameDefine();
            record.setCompanyName(companyNameDefine);
            record.setCompanyId(null);
        }
        record.setActive(Boolean.valueOf(true));
        record.setUpdateBy(currentUser.getUsername());
        record.setUpdateTime(new Date());
        record.setUpdateflag(Boolean.valueOf(true));
        record.setUserid(currentUser.getId());
        record.setAreaCode(currentUser.getPolice().getAreacode());
        this.companyPunishDaoAop.save(record);
    }

    public CompanyPunish findById(Long id) {
        return this.companyPunishDao.findById(id);
    }

    public void searchForPage(SearchDto dto, AjaxPageResponse page) {
        dto.setPoliceBusiness(false);
        this.arsUtil.setPoliceSearch(dto);
        CompanyPunishPageSearchDto searchDto = (CompanyPunishPageSearchDto)dto;
        if (StringUtil.isNotEmpty((String)searchDto.getOrgAreaCode())) {
            if (searchDto.getOrgAreaCode().endsWith("0000")) {
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode().substring(0, 2) + "____");
            } else if (searchDto.getOrgAreaCode().endsWith("00")) {
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode().substring(0, 4) + "__");
            } else {
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode());
            }
        }
        this.companyPunishDao.searchForPage((CompanyPunishPageSearchDto)dto, page);
    }

    public List<CompanyPunish> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.companyPunishDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(List<CompanyPunish> list) {
        ArrayList<CompanyPunish> dbList = new ArrayList<CompanyPunish>();
        for (CompanyPunish companyPunish : list) {
            CompanyPunish companyPunishIn = this.companyPunishDao.findById(companyPunish.getId());
            if (companyPunishIn == null) {
                companyPunish.setUpdateflag(Boolean.valueOf(false));
                continue;
            }
            if (companyPunish.getUpdateTime().getTime() < companyPunishIn.getUpdateTime().getTime()) {
                dbList.add(companyPunish);
            }
            companyPunish.setUpdateflag(Boolean.valueOf(true));
        }
        list.removeAll(dbList);
        this.companyPunishDaoAop.saveBatch(list);
    }

    public List<CompanyPunish> findDSOutList(String startDate) {
        return this.companyPunishDao.findDSOutList(startDate);
    }

    public void importBatch(List<CompanyPunish> list) {
        List dbList = this.companyPunishDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (CompanyPunish companyPunish : list) {
                companyPunish.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    companyPunish.setUpdateTime(DateUtil.dateAdd((int)6, (Date)companyPunish.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.companyPunishDaoAop.saveBatch(list);
        }
    }
}

