/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.statistics;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.ProblemPersonDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.appeal.AppealDao;
import com.bcxin.ars.dao.msg.NewsnoticeCompanyDao;
import com.bcxin.ars.dao.sb.GradeClassDao;
import com.bcxin.ars.dao.sb.GradePersonDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sb.SponsorlicenseDao;
import com.bcxin.ars.dao.sb.TraincompanyapplyDao;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.ProblemPersonSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.appeal.AppealSearchDto;
import com.bcxin.ars.dto.page.ApprovalPageSearchDto;
import com.bcxin.ars.dto.page.PersonPageSearchDto;
import com.bcxin.ars.dto.sb.PersoncertificateSearchDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.statistics.PoliceNoticeStatisticsService;
import com.bcxin.ars.service.sxzw.impl.SxZwServiceImpl;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.StringUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PoliceNoticeStatisticsServiceImpl
implements PoliceNoticeStatisticsService {
    private static final Logger logger = LoggerFactory.getLogger(SxZwServiceImpl.class);
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private GradePersonDao gradePersonDao;
    @Autowired
    private ProblemPersonDao problemPersonDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private NewsnoticeCompanyDao newsnoticeCompanyDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private PersoncertificateDao personcertificateDao;
    @Autowired
    private TraincompanyapplyDao traincompanyapplyDao;
    @Autowired
    private SponsorlicenseDao sponsorlicenseDao;
    @Autowired
    private UserService userService;
    @Autowired
    private GradeClassDao gradeClassDao;
    @Autowired
    private AppealDao appealDao;

    public JSONObject getPoliceNotice(Map<Object, Object> p) {
        Police police;
        User currentUser = this.arsUtil.getCurrentUser();
        PersoncertificateSearchDto searchDto = new PersoncertificateSearchDto();
        ApprovalPageSearchDto appSearchDto = new ApprovalPageSearchDto();
        appSearchDto.setUserid(currentUser.getId());
        appSearchDto.setSearchType("001");
        List roles = currentUser.getRoles();
        if (roles != null && roles.size() > 0) {
            p.put("roles", roles);
        }
        if (currentUser.getPoliceman() != null && currentUser.getPoliceman().booleanValue()) {
            p.put("policeid", currentUser.getId());
            p.put("taskDefinitionKey", "policeman");
        }
        if ((police = this.policeDao.findById(currentUser.getOrgid())).getOrgtype() != null && police.getOrgtype().equals("4")) {
            p.put("orgid", police.getId());
            searchDto.setOrgid(police.getId());
        }
        p.put("orgtype", police.getOrgtype());
        String areacode = police.getAreacode();
        if (p.get("areaCode") != null) {
            areacode = String.valueOf(p.get("areaCode"));
        }
        if (StringUtil.isNotEmpty((String)areacode)) {
            if (areacode.endsWith("0000")) {
                p.put("areaCode", areacode.substring(0, 2) + "____");
                p.put("district", areacode.substring(0, 2) + "____");
                searchDto.setDistrict(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                p.put("areaCode", areacode.substring(0, 4) + "__");
                p.put("district", areacode.substring(0, 4) + "__");
                searchDto.setDistrict(areacode.substring(0, 4) + "__");
            } else {
                p.put("areaCode", areacode);
                p.put("district", areacode);
                searchDto.setDistrict(areacode);
            }
        }
        searchDto.setPlatform(currentUser.getPlatform().toString());
        p.put("platform", currentUser.getPlatform());
        if (currentUser.getUserBusinessTypeList() != null && currentUser.getUserBusinessTypeList().size() > 0) {
            p.put("userBusinessTypeList", currentUser.getUserBusinessTypeList());
        }
        JSONObject result = new JSONObject();
        Integer approvalCount = 0;
        Long unFingercardCount = 0L;
        Long unPayCount = 0L;
        Integer unReplyComCount = 0;
        Integer unUploadComCount = 0;
        Integer unCardComCount = 0;
        Integer unReplyTrainCount = 0;
        Integer unUploadTrainCount = 0;
        Integer unCardTrainCount = 0;
        Integer unPrintCount = 0;
        Long gradeClassUnApprovalCount = 0L;
        searchDto.setFinished("002");
        searchDto.setFingercardState("0");
        try {
            unFingercardCount = this.personcertificateDao.queryTableCount(searchDto);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        searchDto.setFingercardState("3");
        searchDto.setFeeState("0");
        try {
            unPayCount = this.personcertificateDao.queryTableCount(searchDto);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        Config isReplyConfig = this.configUtils.getConfigByKey("IS_REPLY");
        p.put("userid", currentUser.getId());
        try {
            this.approvalDAO.searchForPage_count(appSearchDto);
            approvalCount = this.approvalDAO.searchForPage_count(appSearchDto).intValue();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        p.put("userid", null);
        if (this.userService.checkRole(currentUser, p.get("czjsid")).booleanValue()) {
            try {
                p.put("totalType", "001");
                unReplyComCount = this.sponsorlicenseDao.countSponsorlicenseList(p);
                p.put("totalType", "001");
                unReplyTrainCount = this.traincompanyapplyDao.countTraincompanyapplyList(p);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (null != currentUser.getPoliceman()) {
            try {
                if (isReplyConfig == null || null != isReplyConfig && "1".equals(isReplyConfig.getValue())) {
                    p.put("totalType", "002");
                    unUploadComCount = this.sponsorlicenseDao.countSponsorlicenseList(p);
                    p.put("totalType", "002");
                    unUploadTrainCount = this.traincompanyapplyDao.countTraincompanyapplyList(p);
                }
                if (isReplyConfig == null || null != isReplyConfig && "1".equals(isReplyConfig.getValue())) {
                    p.put("totalType", "003");
                    unCardComCount = this.sponsorlicenseDao.countSponsorlicenseList(p);
                    p.put("totalType", "003");
                    unCardTrainCount = this.traincompanyapplyDao.countTraincompanyapplyList(p);
                } else {
                    p.put("totalType", "004");
                    unCardComCount = this.sponsorlicenseDao.countSponsorlicenseList(p);
                    p.put("totalType", "004");
                    unCardTrainCount = this.traincompanyapplyDao.countTraincompanyapplyList(p);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        try {
            if (!"11".equals(this.configUtils.getCurrentNative())) {
                p.put("havephoto", "1");
                p.put("isprint", "0");
                unPrintCount = this.personcertificateDao.countPrintList(p);
            } else {
                p.put("isOldData", "0");
                p.put("isprint", "0");
                unPrintCount = this.personcertificateDao.countPrintList(p);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        ProblemPersonSearchDto problemPersonSearchDto = new ProblemPersonSearchDto();
        if (areacode.endsWith("0000")) {
            problemPersonSearchDto.setAreaCode(areacode.substring(0, 2) + "____");
        } else if (areacode.endsWith("00")) {
            problemPersonSearchDto.setAreaCode(areacode.substring(0, 4) + "__");
        } else {
            problemPersonSearchDto.setAreaCode(areacode);
        }
        if ("4".equals(police.getOrgtype())) {
            problemPersonSearchDto.setOrgId(police.getId());
        }
        try {
            problemPersonSearchDto.setPersonType("3");
            result.put("problemCount", (Object)this.problemPersonDao.getProblemTotalCount(problemPersonSearchDto));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.put("problemCount", (Object)"0");
        }
        try {
            problemPersonSearchDto.setPersonType("2");
            result.put("atLargePersonCount", (Object)this.problemPersonDao.getProblemTotalCount(problemPersonSearchDto));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.put("atLargePersonCount", (Object)"0");
        }
        try {
            problemPersonSearchDto.setPersonType("1");
            result.put("errorInfoPersonCount", (Object)this.problemPersonDao.getProblemTotalCount(problemPersonSearchDto));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.put("errorInfoPersonCount", (Object)"0");
        }
        Config daysConfig = this.configUtils.getConfigByKey("person_outtime");
        if (daysConfig == null) {
            daysConfig = new Config();
            daysConfig.setValue("20");
        }
        PersonPageSearchDto personPageSearchDto = new PersonPageSearchDto();
        personPageSearchDto.setStartDay(Long.valueOf(Long.parseLong(daysConfig.getValue())));
        this.arsUtil.setPoliceSearch((SearchDto)personPageSearchDto);
        try {
            result.put("unReadNewsCount", (Object)this.newsnoticeCompanyDao.countUnread(currentUser.getId()));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.put("unReadNewsCount", (Object)"0");
        }
        try {
            AppealSearchDto appealSearchDto = new AppealSearchDto();
            this.arsUtil.setPoliceSearch((SearchDto)appealSearchDto);
            appealSearchDto.setAppealState("002");
            result.put("appealCount", (Object)this.appealDao.appealCount(appealSearchDto));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.put("appealCount", (Object)"0");
        }
        result.put("approvalCount", (Object)approvalCount);
        result.put("unFingercardCount", (Object)unFingercardCount);
        result.put("unPayCount", (Object)unPayCount);
        result.put("unReplyComCount", (Object)unReplyComCount);
        result.put("unUploadComCount", (Object)unUploadComCount);
        result.put("unCardComCount", (Object)unCardComCount);
        result.put("unReplyTrainCount", (Object)unReplyTrainCount);
        result.put("unUploadTrainCount", (Object)unUploadTrainCount);
        result.put("unCardTrainCount", (Object)unCardTrainCount);
        result.put("unPrintCount", (Object)unPrintCount);
        result.put("gradeClassUnApprovalCount", (Object)this.gradeClassDao.queryUnApprovalCount());
        return result;
    }
}

