/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.sb.TrainrecordDao;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.TrainrecordPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Trainrecord;
import com.bcxin.ars.service.sb.TrainrecordService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DataSyncAnnotation(getClazz=Trainrecord.class, getMethodName="importBatch", getImportType=ImportType.BATCH)
public class TrainrecordServiceImpl
implements TrainrecordService {
    Logger logger = LoggerFactory.getLogger(TrainrecordServiceImpl.class);
    @Autowired
    private ApprovalUtil approvalUtil;
    @Autowired
    private TrainrecordDao trainrecordDao;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdWorker idWorker;

    public int delete(Trainrecord trainrecord) {
        User currentUser = this.arsUtil.getCurrentUser();
        trainrecord.setUpdateTime(new Date());
        trainrecord.setUpdateBy(currentUser.getUsername());
        return this.trainrecordDao.delete(trainrecord);
    }

    public void save(Trainrecord trainrecord) {
        Trainrecord checkTraincompanyapply;
        User currentUser = this.arsUtil.getCurrentUser();
        if (trainrecord.getOrgid() == null) {
            if (trainrecord.getDistrictOrgId() != null) {
                trainrecord.setOrgid(Long.valueOf(Long.parseLong(trainrecord.getDistrictOrgId())));
            } else if (trainrecord.getCityOrgId() != null) {
                trainrecord.setOrgid(Long.valueOf(Long.parseLong(trainrecord.getCityOrgId())));
            } else {
                Police police = (Police)this.policeDao.findByType("1").get(0);
                trainrecord.setOrgid(police.getId());
            }
        }
        if (trainrecord.getId() == null) {
            trainrecord.setId(Long.valueOf(this.idWorker.nextId()));
            trainrecord.setCreateTime(new Date());
        } else {
            Trainrecord dbTrainrecord = this.trainrecordDao.findById(trainrecord.getId());
            BeanUtils.copyPropertiesIgnore((Object)trainrecord, (Object)dbTrainrecord, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbTrainrecord, (Object)trainrecord, (Boolean)false);
        }
        if (!trainrecord.getApprovalstate().equals("001") && (checkTraincompanyapply = this.trainrecordDao.findApproveByCompanyName(trainrecord.getCompanyname())) != null) {
            throw new ArsException(trainrecord.getCompanyname() + "\u5df2\u5907\u6848\uff0c\u4e0d\u80fd\u91cd\u590d\u5907\u6848\uff01");
        }
        trainrecord.setActive(Boolean.valueOf(true));
        trainrecord.setUpdateBy(currentUser.getUsername());
        trainrecord.setUpdateTime(new Date());
        trainrecord.setUpdateflag(Boolean.valueOf(true));
        trainrecord.setUserid(currentUser.getId());
        this.trainrecordDao.save(trainrecord);
        if (trainrecord.getApprovalstate().equals("002")) {
            this.approvalUtil.saveApproval("014", trainrecord.getId(), "activititraincompanyapplyapprovalProcess");
        }
    }

    public Trainrecord findById(Long id) {
        Trainrecord result = this.trainrecordDao.findById(id);
        if (result != null) {
            result.setApproval(this.approvalDAO.findBybusinessidAndType(result.getId(), "014"));
            Police police = this.policeDao.findById(result.getOrgid());
            result.setPolice(police);
        }
        return result;
    }

    public void searchForPage(TrainrecordPageSearchDto dto, AjaxPageResponse page) {
        User user;
        dto.setPoliceBusiness(false);
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        if (Constants.CHECKTYPE_APPROVE.equals(dto.getCheckType()) && (user = this.arsUtil.getCurrentUser()) != null) {
            dto.setUserid(user.getId());
        }
        this.trainrecordDao.searchForPage(dto, page);
    }

    public void importBatch(List<Trainrecord> list) {
        List dbList = this.trainrecordDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (Trainrecord trainrecord : list) {
                trainrecord.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    trainrecord.setUpdateTime(DateUtil.dateAdd((int)6, (Date)trainrecord.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.trainrecordDao.saveBatch(list);
        }
    }

    public List<Trainrecord> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.trainrecordDao.searchForDataSynchronization(dto);
    }

    public List<Trainrecord> findDSOutList(String startDate) {
        return this.trainrecordDao.findDSOutList(startDate);
    }

    public List<Trainrecord> findByBatchId(List<Trainrecord> list) {
        return this.trainrecordDao.findByBatchId(list);
    }

    public Trainrecord findByUser(Long userid) {
        return this.trainrecordDao.findByUser(userid);
    }

    public void saveOrUpdateForApprovalImport(Trainrecord trainrecord) {
        this.trainrecordDao.updateSelective(trainrecord);
    }

    public void updateSelective(Trainrecord trainrecord) {
        User currentUser = this.arsUtil.getCurrentUser();
        trainrecord.setUpdateTime(new Date());
        trainrecord.setUpdateBy(currentUser.getUsername());
        this.trainrecordDao.updateSelective(trainrecord);
    }
}

