/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.TrainChangeworkexperienceDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.TrainChangeworkexperienceSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.TrainChangeworkexperience;
import com.bcxin.ars.service.sb.TrainChangeworkexperienceService;
import com.bcxin.ars.service.util.ArsUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=TrainChangeworkexperience.class)
public class TrainChangeworkexperienceServiceImpl
implements TrainChangeworkexperienceService {
    @Autowired
    private TrainChangeworkexperienceDao workexperienceDao;
    @Autowired
    private ArsUtil arsUtil;

    public TrainChangeworkexperience findById(long id) {
        return this.workexperienceDao.findById(id);
    }

    public void saveOrUpdate(TrainChangeworkexperience workexperience) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (workexperience.getId() == null) {
            workexperience.setActive(Boolean.valueOf(true));
            workexperience.setCreateTime(new Date());
            workexperience.setUpdateTime(new Date());
            workexperience.setUpdateBy(currentUser.getUsername());
            this.workexperienceDao.save(workexperience);
        } else {
            TrainChangeworkexperience dbTrainChangeworkexperience = this.workexperienceDao.findById(workexperience.getId().longValue());
            dbTrainChangeworkexperience.setUpdateTime(new Date());
            dbTrainChangeworkexperience.setCompanyname(workexperience.getCompanyname());
            dbTrainChangeworkexperience.setEnddate(workexperience.getEnddate());
            dbTrainChangeworkexperience.setPost(workexperience.getPost());
            dbTrainChangeworkexperience.setStartdate(workexperience.getStartdate());
            dbTrainChangeworkexperience.setUpdateBy(currentUser.getUsername());
            dbTrainChangeworkexperience.setUpdateTime(new Date());
            this.workexperienceDao.update(dbTrainChangeworkexperience);
        }
    }

    public TrainChangeworkexperienceSearchDto search(TrainChangeworkexperienceSearchDto dto) {
        TrainChangeworkexperienceSearchDto resultDto = new TrainChangeworkexperienceSearchDto();
        List list = this.workexperienceDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.workexperienceDao.searchCount(dto));
        return resultDto;
    }

    public void delete(Long workexperienceId) {
        User currentUser = this.arsUtil.getCurrentUser();
        TrainChangeworkexperience workexperience = this.workexperienceDao.findById(workexperienceId.longValue());
        workexperience.setUpdateBy(currentUser.getUsername());
        workexperience.setUpdateTime(new Date());
        this.workexperienceDao.delete(workexperience);
    }

    public void deleteByTrainChangeId(Long trainChangeId) {
        User currentUser = this.arsUtil.getCurrentUser();
        TrainChangeworkexperience workexperience = new TrainChangeworkexperience();
        workexperience.setTrainChangeId(trainChangeId);
        workexperience.setUpdateBy(currentUser.getUsername());
        workexperience.setUpdateTime(new Date());
        this.workexperienceDao.deleteByTrainChangeId(workexperience);
    }

    public List<TrainChangeworkexperience> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.workexperienceDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(TrainChangeworkexperience trainChangeworkexperience) {
        TrainChangeworkexperience dbTrainChangeworkexperience;
        if (trainChangeworkexperience.getActive() == null) {
            trainChangeworkexperience.setActive(Boolean.valueOf(true));
        }
        if ((dbTrainChangeworkexperience = this.workexperienceDao.findById(trainChangeworkexperience.getId().longValue())) != null) {
            if (trainChangeworkexperience.getUpdateTime().getTime() > dbTrainChangeworkexperience.getUpdateTime().getTime()) {
                this.workexperienceDao.update(trainChangeworkexperience);
            }
        } else {
            this.workexperienceDao.saveForDS(trainChangeworkexperience);
        }
    }

    public List<TrainChangeworkexperience> findByTrainChangeId(Long trainChangeId) {
        return this.workexperienceDao.findByTrainChangeId(trainChangeId);
    }
}

