/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.msg.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.msg.NewsnoticeRecipientDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.msg.NewsnoticeRecipient;
import com.bcxin.ars.service.msg.NewsnoticeRecipientService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.DateUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=NewsnoticeRecipient.class)
@DataSyncOutAnnotation(getClazz=NewsnoticeRecipient.class)
public class NewsnoticeRecipientServiceImpl
implements NewsnoticeRecipientService {
    public static final Logger logger = LoggerFactory.getLogger(NewsnoticeRecipientServiceImpl.class);
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private NewsnoticeRecipientDao newsnoticeRecipientDao;

    public List<NewsnoticeRecipient> findDSOutList(String startDate) {
        return this.newsnoticeRecipientDao.searchFromInToOutForExport(startDate);
    }

    public void saveOrUpdateForImport(NewsnoticeRecipient newsnoticeRecipient) {
        try {
            newsnoticeRecipient.setUpdateflag(Boolean.valueOf(false));
            NewsnoticeRecipient dbNewsnoticeRecipient = this.newsnoticeRecipientDao.findById(newsnoticeRecipient.getId());
            if (dbNewsnoticeRecipient == null) {
                newsnoticeRecipient.setUpdateTime(DateUtil.dateAdd2((int)6, (Date)newsnoticeRecipient.getUpdateTime(), (int)1));
                this.newsnoticeRecipientDao.saveForDS(newsnoticeRecipient);
            } else if (newsnoticeRecipient.getUpdateTime().getTime() > dbNewsnoticeRecipient.getUpdateTime().getTime()) {
                newsnoticeRecipient.setUpdateTime(DateUtil.dateAdd2((int)6, (Date)newsnoticeRecipient.getUpdateTime(), (int)1));
                this.newsnoticeRecipientDao.updateForDS(newsnoticeRecipient);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<NewsnoticeRecipient> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.newsnoticeRecipientDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(NewsnoticeRecipient newsnoticeRecipient) {
        NewsnoticeRecipient dbnewsnoticeRecipient;
        newsnoticeRecipient.setUpdateflag(Boolean.valueOf(false));
        if (newsnoticeRecipient.getActive() == null) {
            newsnoticeRecipient.setActive(Boolean.valueOf(true));
        }
        if ((dbnewsnoticeRecipient = this.newsnoticeRecipientDao.findById(newsnoticeRecipient.getId())) != null && newsnoticeRecipient.getUpdateTime().getTime() > dbnewsnoticeRecipient.getUpdateTime().getTime()) {
            this.newsnoticeRecipientDao.updateForDS(newsnoticeRecipient);
        }
    }

    public void importBatch(List<NewsnoticeRecipient> list) {
        List dbList = this.newsnoticeRecipientDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (NewsnoticeRecipient detail : list) {
                detail.setUpdateflag(Boolean.valueOf(false));
                try {
                    detail.setUpdateTime(DateUtil.dateAdd((int)6, (Date)detail.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            this.newsnoticeRecipientDao.saveBatch(list);
        }
    }
}

