/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.task.TaskDao;
import com.bcxin.ars.dto.PersonSearchDto;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.service.task.TaskService;
import com.bcxin.ars.util.MapDistance;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrgentTaskThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(UrgentTaskThread.class);
    private TaskDao taskDao;
    private SecurityPersonDao personDao;
    private TaskService taskService;
    private int minute;
    private Long taskId;

    @Override
    public void run() {
        try {
            Task task = this.taskDao.findUrgentById(this.taskId);
            if (task == null) {
                logger.error("\u83b7\u53d6\u4e0d\u5230\u4efb\u52a1\u4fe1\u606f!!!!");
                return;
            }
            if (task.getTaskStatus() != null && task.getTaskStatus().getId().equals(3)) {
                logger.error("\u4efb\u52a1\u7ed3\u675f !!!!");
                return;
            }
            String longitude = task.getLongitude();
            String latitude = task.getLatitude();
            Map map = MapDistance.getAround((String)latitude, (String)longitude, (String)(task.getScope() + task.getSendcount() * 3000 + ""));
            PersonSearchDto dto = new PersonSearchDto();
            String minLat = (String)map.get("minLat");
            dto.setMinLat(minLat);
            String maxLat = (String)map.get("maxLat");
            dto.setMaxLat(maxLat);
            String minLng = (String)map.get("minLng");
            dto.setMinLng(minLng);
            String maxLng = (String)map.get("maxLng");
            dto.setMaxLng(maxLng);
            dto.setNativeCode(task.getNativeCode());
            if (task.getPeopletype() != null && !"".equals(task.getPeopletype())) {
                String[] types;
                for (String type : types = task.getPeopletype().split(",")) {
                    if (type.equals("1")) {
                        dto.setUrgenttemp(true);
                    }
                    if (!type.equals("2")) continue;
                    dto.setOnline(true);
                }
            }
            List onlinePersons = this.personDao.findOnlineOrUrgentPersons(dto);
            for (SecurityPerson securityPerson : onlinePersons) {
                List list = this.taskDao.findAllByPersonId(securityPerson.getId());
                if (list != null && list.size() > 0 || this.taskService.saveUrgentTaskPerson(task, securityPerson)) continue;
                return;
            }
            if (task.getSendcount() != null && task.getSendcount() > 10) {
                return;
            }
            task.setSendcount(Integer.valueOf(task.getSendcount() + 1));
            task.setUpdateTime(new Date());
            this.taskDao.updateSendCount(task.getId(), task.getSendcount());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return;
        }
    }

    public SecurityPersonDao getPersonDao() {
        return this.personDao;
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public void setPersonDao(SecurityPersonDao personDao) {
        this.personDao = personDao;
    }

    public TaskDao getTaskDao() {
        return this.taskDao;
    }

    public void setTaskDao(TaskDao taskDao) {
        this.taskDao = taskDao;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }
}

