/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyScheduleDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.SecurityCompanySchedule;
import com.bcxin.ars.service.SecurityCompanyScheduleService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=SecurityCompanySchedule.class)
public class SecurityCompanyScheduleServiceImpl
implements SecurityCompanyScheduleService {
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    @Autowired
    private SecurityCompanyScheduleDao securityCompanyScheduleDao;
    @Autowired
    private ArsUtil arsUtil;

    public List<SecurityCompanySchedule> findByCompanyId(Long companyId) {
        return this.securityCompanyScheduleDao.findByCompanyId(companyId);
    }

    public SecurityCompanySchedule findById(Long id) {
        return this.securityCompanyScheduleDao.findById(id);
    }

    public void saveOrUpdate(SecurityCompanySchedule schedule) {
        SecurityCompanySchedule dbSchedule = this.securityCompanyScheduleDao.findById(schedule.getId());
        if (dbSchedule == null) {
            if (null == schedule.getId()) {
                schedule.setId(Long.valueOf(this.idGeneratorUtil.createID()));
            }
            schedule.setNativeCode(this.arsUtil.getCurrentNatvie());
            schedule.setCreateTime(new Date());
            schedule.setUpdateTime(schedule.getCreateTime());
            schedule.setUpdateBy(this.arsUtil.getCurrentUser().getRealname());
            this.securityCompanyScheduleDao.save(schedule);
        } else if (dbSchedule != null) {
            dbSchedule.setUpdateTime(new Date());
            dbSchedule.setUpdateBy(this.arsUtil.getCurrentUser().getRealname());
            if (schedule.getName() != null && schedule.getName().trim().length() > 0) {
                dbSchedule.setName(schedule.getName());
            }
            if (schedule.getStartTime() != null && schedule.getStartTime().trim().length() > 0) {
                dbSchedule.setStartTime(schedule.getStartTime());
            }
            if (schedule.getEndTime() != null && schedule.getEndTime().trim().length() > 0) {
                dbSchedule.setEndTime(schedule.getEndTime());
            }
            this.securityCompanyScheduleDao.update(dbSchedule);
        }
    }

    public void saveOrUpdateForDS(SecurityCompanySchedule schedule) {
        if (schedule.getActive() == null) {
            schedule.setActive(Boolean.valueOf(true));
        }
        if (!schedule.getActive().booleanValue()) {
            this.securityCompanyScheduleDao.delete(schedule);
            return;
        }
        SecurityCompanySchedule dbSchedule = this.findById(schedule.getId());
        if (dbSchedule == null) {
            this.securityCompanyScheduleDao.saveForDS(schedule);
        } else if (schedule.getUpdateTime().getTime() > dbSchedule.getUpdateTime().getTime()) {
            this.securityCompanyScheduleDao.update(schedule);
        }
    }

    public void delete(SecurityCompanySchedule schedule) {
        SecurityCompanySchedule dbSchedule = this.securityCompanyScheduleDao.findById(schedule.getId());
        if (dbSchedule != null && dbSchedule.getCompanyId().longValue() == schedule.getCompanyId().longValue()) {
            schedule.setUpdateTime(new Date());
            this.securityCompanyScheduleDao.delete(schedule);
        }
    }

    public long findByCompanyIdWithTask(long id) {
        return this.securityCompanyScheduleDao.findByCompanyIdWithTask(id);
    }

    public List<SecurityCompanySchedule> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.securityCompanyScheduleDao.searchForDataSynchronization(searchDto);
    }
}

