/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.ProblemPersonDao;
import com.bcxin.ars.dao.ProblemPersonDaoAop;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.PersonSearchDto;
import com.bcxin.ars.dto.ProblemPersonReportDto;
import com.bcxin.ars.dto.ProblemPersonSearchDto;
import com.bcxin.ars.dto.SAASMessageDto;
import com.bcxin.ars.dto.SaaSCompany;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.ProblemPerson;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.ProblemPersonService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.service.util.SysDictUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=ProblemPerson.class)
@DataSyncOutAnnotation(getClazz=ProblemPerson.class)
public class ProblemPersonServiceImpl
implements ProblemPersonService {
    private static final Logger logger = LoggerFactory.getLogger(ProblemPersonServiceImpl.class);
    @Autowired
    private ProblemPersonDao problemPersonDao;
    @Autowired
    private ProblemPersonDaoAop problemPersonDaoAop;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private SecurityPersonDao personDao;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private SysDictUtils sysDictUtils;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;

    public void search(ProblemPersonSearchDto searchDto, AjaxPageResponse page) {
        User currentUser = this.arsUtil.getCurrentUser();
        this.arsUtil.setPoliceSearch((SearchDto)searchDto);
        if (1 == currentUser.getPlatform()) {
            this.arsUtil.setPoliceSearch((SearchDto)searchDto);
        } else {
            SecurityCompany company = this.securityCompanyDao.findByUserid(currentUser.getId());
            searchDto.setCompanyId(company.getId());
        }
        this.problemPersonDao.search(searchDto, page);
    }

    public void searchall(ProblemPersonSearchDto searchDto, AjaxPageResponse page) {
        User currentUser = this.arsUtil.getCurrentUser();
        this.arsUtil.setPoliceSearch((SearchDto)searchDto);
        if (1 == currentUser.getPlatform()) {
            this.arsUtil.setPoliceSearch((SearchDto)searchDto);
        } else {
            SecurityCompany company = this.securityCompanyDao.findByUserid(currentUser.getId());
            searchDto.setCompanyId(company.getId());
        }
        this.problemPersonDao.searchall(searchDto, page);
    }

    public void saveOrUpdate(ProblemPerson problemPerson) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (problemPerson.getId() == null) {
            problemPerson.setCreateTime(new Date());
            problemPerson.setUpdateflag(Boolean.valueOf(true));
            problemPerson.setUpdateBy(currentUser.getUsername());
            this.problemPersonDao.save(problemPerson);
        } else {
            ProblemPerson dbProblemPerson = this.problemPersonDao.findById(problemPerson.getId());
            dbProblemPerson.setCompanyid(problemPerson.getCompanyid());
            dbProblemPerson.setCompanyname(problemPerson.getCompanyname());
            dbProblemPerson.setDispose(problemPerson.getDispose());
            dbProblemPerson.setIdnumber(problemPerson.getIdnumber());
            dbProblemPerson.setName(problemPerson.getName());
            dbProblemPerson.setPhone(problemPerson.getPhone());
            dbProblemPerson.setProblemtype(problemPerson.getProblemtype());
            dbProblemPerson.setSex(problemPerson.getSex());
            dbProblemPerson.setSuggestion(problemPerson.getSuggestion());
            dbProblemPerson.setUpdateBy(currentUser.getUsername());
            dbProblemPerson.setUpdateTime(new Date());
            dbProblemPerson.setCz(problemPerson.getCz());
            dbProblemPerson.setXd(problemPerson.getXd());
            dbProblemPerson.setZt(problemPerson.getZt());
            dbProblemPerson.setWf(problemPerson.getWf());
            dbProblemPerson.setUpdateflag(Boolean.valueOf(true));
            this.problemPersonDaoAop.update(dbProblemPerson);
        }
    }

    public void delete(ProblemPerson problemPerson) {
        User currentUser = this.arsUtil.getCurrentUser();
        problemPerson.setUpdateBy(currentUser.getUsername());
        problemPerson.setUpdateTime(new Date());
        problemPerson.setUpdateflag(Boolean.valueOf(true));
        this.problemPersonDaoAop.delete(problemPerson);
    }

    public ProblemPerson findById(Long id) {
        return this.problemPersonDao.findById(id);
    }

    public void saveDispose(ProblemPerson problemPerson) {
        User currentUser = this.arsUtil.getCurrentUser();
        ProblemPerson dbProblemPerson = this.problemPersonDao.findById(problemPerson.getId());
        dbProblemPerson.setDispose(problemPerson.getDispose());
        dbProblemPerson.setSuggestion(problemPerson.getSuggestion());
        dbProblemPerson.setInform(problemPerson.getInform());
        dbProblemPerson.setUpdateBy(currentUser.getUsername());
        dbProblemPerson.setHandler(currentUser.getRealname());
        dbProblemPerson.setHandlerOrg(currentUser.getPolice().getOrgname());
        dbProblemPerson.setUpdateTime(new Date());
        dbProblemPerson.setUpdateflag(Boolean.valueOf(true));
        dbProblemPerson.setReson(problemPerson.getReson());
        dbProblemPerson.setCatchState(problemPerson.getCatchState());
        dbProblemPerson.setHandleDate(new Date());
        this.problemPersonDaoAop.update(dbProblemPerson);
    }

    public void saveCompanyDispose(ProblemPerson problemPerson) {
        ProblemPerson dbProblemPerson = this.problemPersonDao.findById(problemPerson.getId());
        dbProblemPerson.setDisposeCompany(problemPerson.getDisposeCompany());
        dbProblemPerson.setCompanyReson(problemPerson.getCompanyReson());
        dbProblemPerson.setUpdateTime(new Date());
        dbProblemPerson.setComHandleDate(new Date());
        this.problemPersonDaoAop.updateForCompany(dbProblemPerson);
    }

    public ProblemPersonReportDto getDataReport(ProblemPersonSearchDto searchDto) {
        ProblemPersonReportDto reportDto = this.problemPersonDao.getProblemPersonReport(searchDto);
        PersonSearchDto dto = new PersonSearchDto();
        User user = this.arsUtil.getCurrentUser();
        dto.setUserid(user.getId());
        dto.setPath(user.getPolice().getPath());
        Long totalCount = this.personDao.searchAllCount(dto);
        reportDto.setTotalCount(totalCount);
        reportDto.setCensorCount(totalCount);
        return reportDto;
    }

    public void saveOrUpdateForDS(ProblemPerson problemPerson) {
        if (problemPerson.getActive() == null) {
            problemPerson.setActive(Boolean.valueOf(true));
        }
        if (!problemPerson.getActive().booleanValue()) {
            this.problemPersonDaoAop.delete(problemPerson);
        } else {
            ProblemPerson dbProblemPerson = this.problemPersonDao.findById(problemPerson.getId());
            if (problemPerson.getUpdateTime().getTime() > dbProblemPerson.getUpdateTime().getTime()) {
                this.problemPersonDaoAop.updateDS(problemPerson);
            }
        }
    }

    public List<ProblemPerson> findProblemPersonList() {
        return this.problemPersonDao.findProblemPersonList();
    }

    public List<ProblemPerson> findDSOutList(String startDate) {
        return this.problemPersonDao.searchForExport(startDate);
    }

    public List<String> queryProblemType(String personType) {
        List list = this.problemPersonDao.queryProblemType(personType);
        ArrayList<String> result = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : list) {
            String[] types;
            if (!StringUtil.isNotEmpty((String)s)) continue;
            for (String type : types = s.split(",")) {
                if (map.get(type) != null) continue;
                result.add(type);
                map.put(type, type);
            }
        }
        return result;
    }

    public List<String> queryProblemTypeForCompanyId(Long companyId) {
        List list = this.problemPersonDao.queryProblemTypeForCompanyId(companyId);
        ArrayList<String> result = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : list) {
            String[] types;
            if (!StringUtil.isNotEmpty((String)s)) continue;
            for (String type : types = s.split(",")) {
                if (map.get(type) != null) continue;
                result.add(type);
                map.put(type, type);
            }
        }
        return result;
    }

    public void updateReadstateByidArr(Long[] newIds) {
        this.problemPersonDaoAop.updateReadstateByidArr(newIds);
    }

    public Map<Object, Object> countAlarm() {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        User currentUser = this.arsUtil.getCurrentUser();
        Config config = this.configUtils.getConfigByKey("police");
        if (config.getValue().equals("1") && currentUser != null) {
            Police police = this.policeDao.findById(currentUser.getOrgid());
            String areacode = police.getAreacode();
            ProblemPersonSearchDto problemPersonSearchDto = new ProblemPersonSearchDto();
            if (areacode.endsWith("0000")) {
                problemPersonSearchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                problemPersonSearchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {
                problemPersonSearchDto.setAreaCode(areacode);
            }
            if ("4".equals(police.getOrgtype())) {
                problemPersonSearchDto.setOrgId(police.getId());
            }
            problemPersonSearchDto.setPersonType("3");
            result.put("problemCount", this.problemPersonDao.getProblemTotalOver12(problemPersonSearchDto));
            problemPersonSearchDto.setPersonType("2");
            result.put("atLargePersonCount", this.problemPersonDao.getProblemTotalOver12(problemPersonSearchDto));
            problemPersonSearchDto.setPersonType("1");
            result.put("infoErrorPersonCount", this.problemPersonDao.getProblemTotalOver12(problemPersonSearchDto));
            result.put("problemFirmCount", this.problemPersonDao.getProblemFirmTotalOver12(problemPersonSearchDto));
        }
        return result;
    }

    public Long getUnDisposeQty() {
        User currentUser = this.arsUtil.getCurrentUser();
        SecurityCompany company = this.securityCompanyDao.findByUserid(currentUser.getId());
        return this.problemPersonDao.getUnDisposeQty(company.getId());
    }

    public void importBatch(List<ProblemPerson> list) {
        List dbList = this.problemPersonDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            List idList = list.stream().map(ProblemPerson::getCompanyid).collect(Collectors.toList());
            for (ProblemPerson detail : list) {
                StringBuffer problemtype = new StringBuffer();
                if (StringUtil.isNotEmpty((String)detail.getProblemtype())) {
                    if (detail.getProblemtype().indexOf("\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728") >= 0) {
                        problemtype.append("\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728").append(",");
                    }
                    if (detail.getProblemtype().indexOf("\u59d3\u540d\u4fe1\u606f\u6709\u8bef") >= 0) {
                        problemtype.append("\u59d3\u540d\u4fe1\u606f\u6709\u8bef").append(",");
                    }
                    if (problemtype.length() > 0) {
                        problemtype.deleteCharAt(problemtype.length() - 1);
                        detail.setProblemtype(problemtype.toString());
                    } else {
                        detail.setProblemtype(null);
                    }
                }
                detail.setUpdateflag(Boolean.valueOf(false));
                try {
                    detail.setUpdateTime(DateUtil.dateAdd((int)6, (Date)detail.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            this.problemPersonDaoAop.saveBatch(list);
            new Thread(() -> {
                List companyList = this.securityCompanyDao.findUserNameByBatchId(idList);
                if (companyList != null && companyList.size() > 0) {
                    Map<String, String> localMap = companyList.stream().collect(Collectors.toMap(SaaSCompany::getId, SaaSCompany::getComId));
                    for (ProblemPerson detail : list) {
                        try {
                            if (!"1".equals(detail.getDispose()) || !StringUtil.isEmpty((String)detail.getNewId()) || !StringUtil.isNotEmpty((String)detail.getSuggestion())) continue;
                            SAASMessageDto messageDto = new SAASMessageDto();
                            messageDto.setTitle("\u5173\u4e8e\u95ee\u9898\u4eba\u5458\u7684\u901a\u77e5");
                            String context = "\u5728\u4f8b\u884c\u7cfb\u7edf\u4eba\u5458\u7b5b\u67e5\u4e2d\uff0c\u53d1\u73b0\u516c\u53f8\u4eba\u5458\u5b58\u5728\u95ee\u9898\u4eba\u5458\uff0c\u8bf7\u5728\u7cfb\u7edf\u4e2d\u3010\u4eba\u4e8b\u3011-\u3010\u4eba\u4e8b\u7ba1\u7406\u3011-\u3010\u95ee\u9898\u4eba\u5458\u3011\u4e2d\u67e5\u770b<br/><a style='color: red;'>\u59d3\u540d\uff1a{name}\uff0c\u8eab\u4efd\u8bc1\u53f7\uff1a{idnumber}\uff0c\u516c\u5b89\u673a\u5173\u5efa\u8bae\u5904\u7406\u63aa\u65bd\uff1a{inform}\uff0c\u516c\u5b89\u673a\u5173\u5904\u7406\u610f\u89c1\uff1a{suggestion}</a>";
                            context = context.replace("{name}", detail.getName());
                            context = context.replace("{idnumber}", detail.getIdnumber());
                            String inform = this.sysDictUtils.getDictTypeValue("inform", detail.getInform());
                            context = context.replace("{inform}", inform);
                            context = context.replace("{suggestion}", detail.getSuggestion());
                            messageDto.setContent(context);
                            String comId = localMap.get(detail.getCompanyid() + "");
                            if (StringUtil.isEmpty((String)comId)) {
                                logger.error("\u4fdd\u767e\u76fe\u516c\u53f8id:" + detail.getCompanyid() + "\u6ca1\u6709\u5bf9\u5e94\u7684saas\u516c\u53f8id");
                                return;
                            }
                            messageDto.setComIds(comId);
                            messageDto.setMessageType("050302");
                            messageDto.setPoliceRegionId(detail.getAreaCode());
                            if (StringUtil.isNotEmpty((String)detail.getHandlerOrg())) {
                                messageDto.setSendPer(detail.getHandlerOrg());
                            } else {
                                messageDto.setSendPer(detail.getOrgName());
                            }
                            messageDto.setIsNeedCallBackBBD("1");
                            AjaxResult result = this.saasInterfaceUtil.sendSaasMsg(messageDto);
                            if (result.isSuccessful()) {
                                detail.setNewId(result.getData().toString());
                            }
                            this.problemPersonDaoAop.updateNewId(detail);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }).start();
        }
    }

    public List<ProblemPerson> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.problemPersonDao.searchForDataSynchronization(dto);
    }
}

