/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.OrganizationDao;
import com.bcxin.ars.dao.SecurityCompanyPersonDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.OrganizationSAASDTO;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Organization;
import com.bcxin.ars.model.OrganizationDto;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityCompanyPerson;
import com.bcxin.ars.service.OrganizationService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Organization.class)
public class OrganizationServiceImpl
implements OrganizationService {
    @Autowired
    private OrganizationDao orgDao;
    @Autowired
    private SecurityCompanyPersonDao companyPersonDao;
    @Autowired
    private ArsUtil arsUtil;

    public Organization findById(long id) {
        return this.orgDao.findById(Long.valueOf(id));
    }

    public List<Organization> findByParentId(long parentId) {
        return this.orgDao.findByParentId(Long.valueOf(parentId));
    }

    public void delete(Organization org) {
        List childrenOrgs = this.orgDao.findByParentId(org.getId());
        List companyPerson = this.companyPersonDao.findByOrgId(org.getId());
        if (childrenOrgs != null && childrenOrgs.size() > 0) {
            throw new ArsException("\u8bf7\u5148\u5220\u9664\u4e0b\u7ea7\u90e8\u95e8");
        }
        if (companyPerson.size() > 0) {
            String error = "\u65e0\u6cd5\u5220\u9664ID\u4e3a\uff1a" + org.getId() + " \u7ec4\u7ec7\u7ed3\u6784, \u8bf7\u5148\u53d8\u66f4\u5982\u4e0b\u4eba\u5458\u7ed3\u6784\uff1a";
            for (SecurityCompanyPerson cp : companyPerson) {
                error = error + cp.getPerson().getRealName() + ",";
            }
            throw new ArsException(error);
        }
        org.setUpdateTime(new Date());
        org.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
        this.orgDao.delete(org);
    }

    public List<Organization> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.orgDao.searchForDataSynchronization(dto);
    }

    public void saveOrUpdate(Organization org) {
        Organization dbOrg = this.orgDao.findById(org.getId());
        if (dbOrg == null) {
            org.setNativeCode(this.arsUtil.getCurrentNatvie());
            org.setActive(Boolean.valueOf(true));
            org.setCreateTime(new Date());
            org.setUpdateTime(org.getCreateTime());
            org.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
            this.orgDao.save(org);
        } else if (dbOrg != null) {
            dbOrg.setUpdateTime(new Date());
            dbOrg.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
            if (!StringUtils.isEmpty((Object)org.getName())) {
                dbOrg.setName(org.getName());
            }
            if (org.getCompany() != null && org.getCompany().getId() != null && org.getCompany().getId() > 0L) {
                dbOrg.setCompany(org.getCompany());
            }
            if (org.getParent() != null && org.getParent().getId() != null && org.getParent().getId() > 0L) {
                dbOrg.setParent(org.getParent());
            } else {
                dbOrg.setParent(null);
            }
            this.orgDao.update(dbOrg);
        }
    }

    public void saveOrUpdateBatch(List<OrganizationSAASDTO> organizationSAASDTOList, SecurityCompany company) {
        ArrayList<OrganizationSAASDTO> noExistList = new ArrayList<OrganizationSAASDTO>();
        ArrayList<OrganizationSAASDTO> organizationList = new ArrayList<OrganizationSAASDTO>();
        List dbOrgList = this.orgDao.findByBatchId(organizationSAASDTOList);
        String username = this.arsUtil.getCurrentUser().getUsername();
        Date newDate = new Date();
        for (OrganizationSAASDTO org : organizationSAASDTOList) {
            noExistList.add(org);
            if (dbOrgList.size() > 0) {
                for (Organization dbOrg : dbOrgList) {
                    if (!dbOrg.getId().equals(org.getId())) continue;
                    noExistList.remove(org);
                    OrganizationSAASDTO organizationSAASDTO = new OrganizationSAASDTO();
                    BeanUtils.copyPropertiesIgnore((Object)dbOrg, (Object)organizationSAASDTO, (Boolean)true);
                    organizationSAASDTO.setUpdateTime(newDate);
                    organizationSAASDTO.setUpdateBy(username);
                    if (!StringUtils.isEmpty((Object)org.getName())) {
                        organizationSAASDTO.setName(org.getName());
                    }
                    if (company != null && company.getId() != null && company.getId() > 0L) {
                        organizationSAASDTO.setCompanyId(company.getId());
                    }
                    if (org.getParentId() != null && org.getParentId() > 0L) {
                        organizationSAASDTO.setParentId(org.getParentId());
                    }
                    organizationList.add(organizationSAASDTO);
                }
            }
            if (noExistList.size() <= 0) continue;
            for (OrganizationSAASDTO noExist : noExistList) {
                noExist.setNativeCode(this.arsUtil.getCurrentNatvie());
                noExist.setActive(Boolean.valueOf(true));
                noExist.setCreateTime(newDate);
                noExist.setUpdateTime(org.getCreateTime());
                noExist.setUpdateBy(username);
                organizationList.add(noExist);
            }
        }
        this.orgDao.updateBatch(organizationList);
    }

    public List<Organization> findByCompany(long companyId) {
        return this.orgDao.findByCompany(Long.valueOf(companyId));
    }

    public void saveOrUpdateForDS(Organization organization) {
        if (organization.getActive() == null) {
            organization.setActive(Boolean.valueOf(true));
        }
        if (!organization.getActive().booleanValue()) {
            this.orgDao.delete(organization);
            return;
        }
        Organization dbOrganization = this.findById(organization.getId());
        if (dbOrganization == null) {
            this.orgDao.saveForDS(organization);
        } else if (organization.getUpdateTime().getTime() > dbOrganization.getUpdateTime().getTime()) {
            this.orgDao.update(organization);
        }
    }

    public Long queryCount(Organization organization) {
        return this.orgDao.queryCount(organization);
    }

    public List<OrganizationDto> findOrgInfoByCompanyId(long companyId) {
        return this.orgDao.findOrgInfoByCompanyId(companyId);
    }

    public List<OrganizationDto> findByParentIdAndCompanyId(OrganizationDto orgDto) {
        return this.orgDao.findByParentIdAndCompanyId(orgDto);
    }
}

