/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.gx;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.certificate.SecurityCertificateDao;
import com.bcxin.ars.dao.gx.InternetPlusBusinessDao;
import com.bcxin.ars.dao.sb.LegalchangeworkexperienceDao;
import com.bcxin.ars.dao.sb.SbSponsorlicenseManagerDao;
import com.bcxin.ars.dao.sb.SbSponsorlicenseVmanagerDao;
import com.bcxin.ars.dao.sb.ShareholderDao;
import com.bcxin.ars.dao.sb.SponsorlicenseDao;
import com.bcxin.ars.dao.sys.SysareaDAO;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.gx.RequestDto;
import com.bcxin.ars.dto.gx.SecCompanyDto;
import com.bcxin.ars.dto.sb.LegalchangeDto;
import com.bcxin.ars.dto.sb.WorkexperienceDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.gx.InternetPlusBusiness;
import com.bcxin.ars.model.sb.Legalchange;
import com.bcxin.ars.model.sb.Legalchangeworkexperience;
import com.bcxin.ars.model.sb.PerCerGrant;
import com.bcxin.ars.model.sb.SbSponsorlicenseManager;
import com.bcxin.ars.model.sb.SbSponsorlicenseVmanager;
import com.bcxin.ars.model.sb.Shareholder;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.model.sys.Sysarea;
import com.bcxin.ars.service.gx.InternetPlusBusinessService;
import com.bcxin.ars.service.sb.LegalchangeService;
import com.bcxin.ars.service.sb.PerCerGrantService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.FileUtil;
import com.bcxin.ars.util.Sha1Util;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.BusinessType;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class InternetPlusBusinessServiceImpl
implements InternetPlusBusinessService {
    Logger logger = LoggerFactory.getLogger(InternetPlusBusinessServiceImpl.class);
    @Autowired
    private InternetPlusBusinessDao internetPlusBusinessDao;
    @Autowired
    private SponsorlicenseDao sponsorlicenseDao;
    @Autowired
    private LegalchangeService legalchangeService;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private SysareaDAO sysareaDAO;
    @Autowired
    private UserDao userDao;
    @Autowired
    private LegalchangeworkexperienceDao workexperienceDao;
    @Autowired
    private ShareholderDao shareholderDao;
    @Autowired
    private SbSponsorlicenseManagerDao sponsorlicenseManagerDao;
    @Autowired
    private SbSponsorlicenseVmanagerDao sponsorlicenseVmanagerDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    @Autowired
    private ApprovalUtil approvalUtil;
    @Autowired
    private PerCerGrantService perCerGrantService;
    @Autowired
    private SecurityCertificateDao securityCertificateDao;

    public int delete(InternetPlusBusiness internetPlusBusiness) {
        User currentUser = this.arsUtil.getCurrentUser();
        internetPlusBusiness.setUpdateTime(new Date());
        internetPlusBusiness.setUpdateBy(currentUser.getUsername());
        return this.internetPlusBusinessDao.delete(internetPlusBusiness);
    }

    public int save(InternetPlusBusiness internetPlusBusiness) {
        if (internetPlusBusiness.getId() == null) {
            internetPlusBusiness.setCreateTime(new Date());
        } else {
            InternetPlusBusiness dbInternetPlusBusiness = this.internetPlusBusinessDao.findById(internetPlusBusiness.getId());
            BeanUtils.copyPropertiesIgnore((Object)internetPlusBusiness, (Object)dbInternetPlusBusiness, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbInternetPlusBusiness, (Object)internetPlusBusiness, (Boolean)false);
        }
        internetPlusBusiness.setActive(Boolean.valueOf(true));
        internetPlusBusiness.setUpdateTime(new Date());
        internetPlusBusiness.setUpdateflag(Boolean.valueOf(true));
        return this.internetPlusBusinessDao.save(internetPlusBusiness);
    }

    public InternetPlusBusiness findById(Long id) {
        return this.internetPlusBusinessDao.findById(id);
    }

    public void importBatch(List<InternetPlusBusiness> list) {
        List dbList = this.internetPlusBusinessDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (InternetPlusBusiness internetPlusBusiness : list) {
                internetPlusBusiness.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    internetPlusBusiness.setUpdateTime(DateUtil.dateAdd((int)6, (Date)internetPlusBusiness.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.internetPlusBusinessDao.saveBatch(list);
        }
    }

    public List<InternetPlusBusiness> findDSOutList(String startDate) {
        return this.internetPlusBusinessDao.findDSOutList(startDate);
    }

    public List<InternetPlusBusiness> findByBatchId(List<InternetPlusBusiness> list) {
        return this.internetPlusBusinessDao.findByBatchId(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public AjaxResult saveSponsorlicense(RequestDto requestDto) {
        try {
            Sponsorlicense checkSponsorlicense;
            if (this.internetPlusBusinessDao.findBySdono(requestDto.getSdono()) != null) {
                throw new ArsException("\u4e1a\u52a1\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
            }
            SecCompanyDto sponsorlicenseDto = (SecCompanyDto)JSON.parseObject((String)JSON.toJSONString((Object)requestDto.getSdata()), SecCompanyDto.class);
            User currentUser = this.userDao.findByUsername(requestDto.getSapptel(), String.valueOf(4));
            if (currentUser == null) {
                currentUser = new User();
                currentUser.setPlatform(Integer.valueOf(4));
                currentUser.setUsername(requestDto.getSapptel());
                currentUser.setPhone(requestDto.getSapptel());
                currentUser.setUpdateBy(requestDto.getSapptel());
                currentUser.setPassword(Sha1Util.entryptPassword((String)"Baoan#12345678"));
                currentUser.setRealname(requestDto.getSappname());
                currentUser.setPhoto("assets/images/defaultHead/male.png");
                currentUser.setId(Long.valueOf(this.idGeneratorUtil.createID()));
                currentUser.setNativeCode(Long.valueOf(45L));
                currentUser.setActive(Boolean.valueOf(true));
                currentUser.setCreateTime(new Date());
                currentUser.setUpdateTime(new Date());
                currentUser.setUpdateBy("system");
                this.userDao.save(currentUser);
            }
            Sponsorlicense sponsorlicense = new Sponsorlicense();
            BeanUtils.copyPropertiesIgnore((Object)sponsorlicenseDto, (Object)sponsorlicense);
            sponsorlicense.setProvince("450000");
            if (StringUtil.isEmpty((String)sponsorlicense.getDistrict())) {
                AjaxResult ajaxResult = AjaxResult.error((String)"\u533a\u53bf\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                return ajaxResult;
            }
            sponsorlicense.setCity(sponsorlicense.getDistrict().substring(0, 4) + "00");
            Police police = this.policeDao.findByAreaCode(sponsorlicense.getDistrict());
            if (police == null) {
                AjaxResult ajaxResult = AjaxResult.error((String)"\u533a\u53bf\u4ee3\u7801\u627e\u4e0d\u5230\u529e\u4e8b\u673a\u6784");
                return ajaxResult;
            }
            sponsorlicense.setDistrictOrgId(police.getId().toString());
            sponsorlicense.setCityOrgId(police.getParentorg().toString());
            sponsorlicense.setOrgid(police.getId());
            sponsorlicense.setSponsorlicenseType("01");
            sponsorlicense.setApprovalstate("002");
            sponsorlicense.setUserid(currentUser.getId());
            try {
                Shareholder shareholder = new Shareholder();
                SbSponsorlicenseManager sbSponsorlicenseManager = new SbSponsorlicenseManager();
                SbSponsorlicenseVmanager sbSponsorlicenseVmanager = new SbSponsorlicenseVmanager();
                sponsorlicense.setShareholder(shareholder);
                sponsorlicense.setSbSponsorlicenseManager(sbSponsorlicenseManager);
                sponsorlicense.setSbSponsorlicenseVmanager(sbSponsorlicenseVmanager);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            try {
                if (StrUtil.isNotEmpty((CharSequence)sponsorlicense.getTemplateRar())) {
                    String localPath = this.configUtils.uploadFolder + DateUtil.getCurrentDate();
                    FileUtil.downloadFile((String)sponsorlicense.getTemplateRar(), (String)localPath);
                    sponsorlicense.setTemplateRar(localPath);
                }
            }
            catch (Exception e) {
                this.logger.error("\u9644\u4ef6\u4e0b\u8f7d\u5931\u8d25");
            }
            String processKey = "activitisponsorlicenseapprovalProcess";
            if (StringUtil.isNotEmpty((String)sponsorlicense.getSponsorlicenseType())) {
                processKey = BusinessType.getBusinessTypeName((String)"001", (String)sponsorlicense.getSponsorlicenseType());
            }
            sponsorlicense.setUserid(currentUser.getId());
            if (!sponsorlicense.getApprovalstate().equals("001") && (checkSponsorlicense = this.sponsorlicenseDao.findApproveByCompanyName(sponsorlicense.getCompanyname())) != null) {
                throw new ArsException(sponsorlicense.getCompanyname() + "\u5df2\u5907\u6848\uff0c\u4e0d\u80fd\u91cd\u590d\u5907\u6848\uff01");
            }
            sponsorlicense.setId(Long.valueOf(this.idGeneratorUtil.createID()));
            sponsorlicense.setActive(Boolean.valueOf(true));
            sponsorlicense.setCreateTime(new Date());
            sponsorlicense.setUpdateTime(new Date());
            sponsorlicense.setUpdateBy(currentUser.getUsername());
            this.sponsorlicenseDao.save(sponsorlicense);
            if (sponsorlicenseDto.getShareholderList() != null) {
                for (Shareholder shareholder : sponsorlicenseDto.getShareholderList()) {
                    shareholder.setId(Long.valueOf(this.idGeneratorUtil.createID()));
                    shareholder.setActive(Boolean.valueOf(true));
                    shareholder.setCreateTime(new Date());
                    shareholder.setUpdateTime(new Date());
                    shareholder.setSponsorlicenseid(sponsorlicense.getId());
                    this.shareholderDao.save(shareholder);
                }
            }
            if (sponsorlicenseDto.getGeneralList() != null) {
                for (SbSponsorlicenseManager sponsorlicenseManager : sponsorlicenseDto.getGeneralList()) {
                    sponsorlicenseManager.setId(Long.valueOf(this.idGeneratorUtil.createID()));
                    sponsorlicenseManager.setActive(Boolean.valueOf(true));
                    sponsorlicenseManager.setCreateTime(new Date());
                    sponsorlicenseManager.setUpdateTime(new Date());
                    sponsorlicenseManager.setSponsorlicenseid(sponsorlicense.getId());
                    this.sponsorlicenseManagerDao.save(sponsorlicenseManager);
                }
            }
            if (sponsorlicenseDto.getViceGeneralList() != null) {
                for (SbSponsorlicenseVmanager sponsorlicenseVmanager : sponsorlicenseDto.getViceGeneralList()) {
                    sponsorlicenseVmanager.setId(Long.valueOf(this.idGeneratorUtil.createID()));
                    sponsorlicenseVmanager.setActive(Boolean.valueOf(true));
                    sponsorlicenseVmanager.setCreateTime(new Date());
                    sponsorlicenseVmanager.setUpdateTime(new Date());
                    sponsorlicenseVmanager.setSponsorlicenseid(sponsorlicense.getId());
                    this.sponsorlicenseVmanagerDao.save(sponsorlicenseVmanager);
                }
            }
            this.approvalUtil.saveApprovalForIntegrate("001", sponsorlicense.getId(), processKey, currentUser);
            requestDto.setBusinessId(sponsorlicense.getId());
            AjaxResult ajaxResult = AjaxResult.success();
            return ajaxResult;
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            AjaxResult ajaxResult = AjaxResult.error((String)e.getMessage());
            return ajaxResult;
        }
        finally {
            new Thread(() -> this.save((InternetPlusBusiness)requestDto)).start();
        }
    }

    public void updateSelective(InternetPlusBusiness internetPlusBusiness) {
        User currentUser = this.arsUtil.getCurrentUser();
        internetPlusBusiness.setUpdateTime(new Date());
        internetPlusBusiness.setUpdateBy(currentUser.getUsername());
        this.internetPlusBusinessDao.updateSelective(internetPlusBusiness);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public AjaxResult saveLegalchange(RequestDto requestDto) {
        try {
            if (this.internetPlusBusinessDao.findBySdono(requestDto.getSdono()) != null) {
                AjaxResult ajaxResult = AjaxResult.error((String)"\u4e1a\u52a1\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
                return ajaxResult;
            }
            LegalchangeDto legalchangeDto = (LegalchangeDto)JSON.parseObject((String)JSON.toJSONString((Object)requestDto.getSdata()), LegalchangeDto.class);
            SecurityCompany company = this.securityCompanyDao.findByName(legalchangeDto.getComName());
            if (company == null) {
                AjaxResult ajaxResult = AjaxResult.error((String)("\u65e0\u6cd5\u83b7\u53d6\u3010" + legalchangeDto.getComName() + "\u3011\u516c\u53f8\u4fe1\u606f\uff0c\u8bf7\u4e0e\u5ba2\u670d\u70ed\u7ebf400-662-9696\u54a8\u8be2\uff01"));
                return ajaxResult;
            }
            Legalchange legalchange = new Legalchange();
            BeanUtils.copyPropertiesIgnore((Object)legalchangeDto, (Object)legalchange);
            legalchange.setOldcompanyname(company.getName());
            legalchange.setOldaddress(company.getAddress());
            legalchange.setLicencenum(company.getPublicSecurityLicenseNumber());
            legalchange.setLegalcardtype("1");
            legalchange.setNdlegalcardtype("1");
            legalchange.setProvince("450000");
            legalchange.setCity(company.getAreaCode().substring(0, 4) + "00");
            legalchange.setDistrict(company.getAreaCode());
            Police police = this.policeDao.findById(Long.valueOf(Long.parseLong(company.getOrgId())));
            if (police != null) {
                if ("3".equals(police.getOrgtype())) {
                    legalchange.setOrgid(police.getId());
                    legalchange.setDistrictOrgId(police.getId().toString());
                    legalchange.setCityOrgId(police.getParentorg().toString());
                } else {
                    Police cityPolice = this.policeDao.findById(police.getParentorg());
                    legalchange.setOrgid(police.getId());
                    legalchange.setCityOrgId(police.getId().toString());
                    if (cityPolice != null && "3".equals(cityPolice.getOrgtype())) {
                        legalchange.setCityOrgId(cityPolice.getId().toString());
                    }
                }
            }
            Sysarea sysarea = this.sysareaDAO.findByCode(company.getAreaCode());
            legalchange.setSzss(sysarea.getRegionFullName());
            legalchange.setUserid(company.getUser().getId());
            legalchange.setCompanyid(company.getId());
            legalchange.setApprovalstate("002");
            try {
                if (StrUtil.isNotEmpty((CharSequence)legalchangeDto.getTemplateRar())) {
                    String localPath = this.configUtils.uploadFolder + DateUtil.getCurrentDate();
                    FileUtil.downloadFile((String)legalchangeDto.getTemplateRar(), (String)localPath);
                    legalchange.setTemplateRar(localPath);
                }
            }
            catch (Exception e) {
                this.logger.error("\u9644\u4ef6\u4e0b\u8f7d\u5931\u8d25");
            }
            this.legalchangeService.saveOrUpdateForIntegrate(legalchange, company.getUser());
            requestDto.setBusinessId(legalchange.getId());
            Legalchangeworkexperience legalchangeworkexperience = null;
            if (legalchangeDto.getWorkexperienceList() != null) {
                for (WorkexperienceDto workexperienceDto : legalchangeDto.getWorkexperienceList()) {
                    legalchangeworkexperience = new Legalchangeworkexperience();
                    legalchangeworkexperience.setActive(Boolean.valueOf(true));
                    legalchangeworkexperience.setCompanyname(workexperienceDto.getCompanyname());
                    legalchangeworkexperience.setCreateTime(new Date());
                    legalchangeworkexperience.setEnddate(workexperienceDto.getEnddate());
                    legalchangeworkexperience.setLegalchangeId(legalchange.getId());
                    legalchangeworkexperience.setPost(workexperienceDto.getPost());
                    legalchangeworkexperience.setStartdate(workexperienceDto.getStartdate());
                    legalchangeworkexperience.setUpdateTime(new Date());
                    legalchangeworkexperience.setActive(Boolean.valueOf(true));
                    legalchangeworkexperience.setCreateTime(new Date());
                    legalchangeworkexperience.setUpdateTime(new Date());
                    legalchangeworkexperience.setUpdateBy(company.getUser().getUsername());
                    legalchangeworkexperience.setId(Long.valueOf(this.idGeneratorUtil.createID()));
                    this.workexperienceDao.save(legalchangeworkexperience);
                }
            }
            AjaxResult ajaxResult = AjaxResult.success();
            return ajaxResult;
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            AjaxResult ajaxResult = AjaxResult.error((String)e.getMessage());
            return ajaxResult;
        }
        finally {
            new Thread(() -> this.save((InternetPlusBusiness)requestDto)).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AjaxResult saveCertificateVerification(RequestDto requestDto) {
        try {
            if (this.internetPlusBusinessDao.findBySdono(requestDto.getSdono()) != null) {
                throw new ArsException("\u4e1a\u52a1\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
            }
            PerCerGrant perCerGrant = (PerCerGrant)JSON.parseObject((String)JSON.toJSONString((Object)requestDto.getSdata()), PerCerGrant.class);
            SecurityCertificate securityCertificate = this.securityCertificateDao.findByIdnum(perCerGrant.getIdnumber());
            if (securityCertificate == null || StrUtil.isEmpty((CharSequence)securityCertificate.getAreaCode())) {
                AjaxResult ajaxResult = AjaxResult.success((String)"", (Object)"\u4fdd\u5b89\u5458\u8bc1\u4e0d\u5b58\u5728");
                return ajaxResult;
            }
            User currentUser = null;
            if (securityCertificate.getUserid() == null) {
                currentUser = new User();
                currentUser.setPlatform(Integer.valueOf(4));
                currentUser.setUsername(StrUtil.isEmpty((CharSequence)requestDto.getSapptel()) ? perCerGrant.getPhone() : requestDto.getSapptel());
                currentUser.setPhone(StrUtil.isEmpty((CharSequence)requestDto.getSapptel()) ? perCerGrant.getPhone() : requestDto.getSapptel());
                currentUser.setPassword(Sha1Util.entryptPassword((String)"Baoan#12345678"));
                currentUser.setUsername(StrUtil.isEmpty((CharSequence)requestDto.getSappname()) ? perCerGrant.getName() : requestDto.getSappname());
                currentUser.setId(Long.valueOf(this.idGeneratorUtil.createID()));
                currentUser.setNativeCode(Long.valueOf(45L));
                currentUser.setActive(Boolean.valueOf(true));
                currentUser.setCreateTime(new Date());
                currentUser.setUpdateTime(new Date());
                currentUser.setUpdateBy("system");
                this.userDao.save(currentUser);
            } else {
                currentUser = this.userDao.findById(securityCertificate.getUserid());
            }
            perCerGrant.setApprovalstate("002");
            perCerGrant.setCreateBy("system");
            perCerGrant.setUpdateBy("system");
            perCerGrant.setUserid(currentUser.getId());
            perCerGrant.setProvince("450000");
            perCerGrant.setCity(securityCertificate.getAreaCode().substring(0, 4) + "00");
            perCerGrant.setDistrict(securityCertificate.getAreaCode());
            Police police = this.policeDao.findById(securityCertificate.getOrgId());
            if (police != null) {
                if ("3".equals(police.getOrgtype())) {
                    perCerGrant.setOrgid(police.getId());
                    perCerGrant.setDistrictOrgId(police.getId().toString());
                    perCerGrant.setCityOrgId(police.getParentorg().toString());
                } else {
                    Police cityPolice = this.policeDao.findById(police.getParentorg());
                    perCerGrant.setOrgid(police.getId());
                    perCerGrant.setCityOrgId(police.getId().toString());
                    if (cityPolice != null && "3".equals(cityPolice.getOrgtype())) {
                        perCerGrant.setCityOrgId(cityPolice.getId().toString());
                    }
                }
            }
            Sysarea sysarea = this.sysareaDAO.findByCode(perCerGrant.getDistrict());
            perCerGrant.setSzss(sysarea.getRegionFullName());
            try {
                if (StrUtil.isNotEmpty((CharSequence)perCerGrant.getTemplateRar())) {
                    String localPath = this.configUtils.uploadFolder + DateUtil.getCurrentDate();
                    FileUtil.downloadFile((String)perCerGrant.getTemplateRar(), (String)localPath);
                    perCerGrant.setTemplateRar(localPath);
                }
            }
            catch (Exception e) {
                this.logger.error("\u9644\u4ef6\u4e0b\u8f7d\u5931\u8d25");
            }
            this.perCerGrantService.saveOrUpdateForIntegrate(perCerGrant, currentUser);
            requestDto.setBusinessId(perCerGrant.getId());
            AjaxResult ajaxResult = AjaxResult.success();
            return ajaxResult;
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            AjaxResult ajaxResult = AjaxResult.error((String)e.getMessage());
            return ajaxResult;
        }
        finally {
            new Thread(() -> this.save((InternetPlusBusiness)requestDto)).start();
        }
    }
}

