/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.gx;

import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.gx.DataViewDao;
import com.bcxin.ars.dto.gx.DataViewDTO;
import com.bcxin.ars.dto.singleLogin.SingleUserDTO;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.gx.DataView;
import com.bcxin.ars.service.gx.DataViewService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataViewServiceImpl
implements DataViewService {
    @Autowired
    private DataViewDao dataViewDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private PoliceDao policeDao;

    public DataView query(SingleUserDTO userInfo) {
        User u = this.userDao.findByUsername(userInfo.getUser(), String.valueOf(1));
        DataViewDTO dto = new DataViewDTO();
        if (u != null) {
            Police p = this.policeDao.findById(u.getOrgid());
            String areaCode = p.getAreacode();
            if (areaCode.endsWith("0000")) {
                dto.setAreaCode(areaCode.substring(0, 2) + "____");
            } else if (areaCode.endsWith("00")) {
                dto.setAreaCode(areaCode.substring(0, 4) + "__");
            } else {
                dto.setAreaCode(areaCode);
            }
            if ("4".equals(p.getOrgtype())) {
                dto.setOrgId(p.getId());
            }
        }
        return this.dataViewDao.query(dto);
    }
}

