/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.epidemic;

import com.bcxin.ars.dao.epidemic.RiskAreaDao;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.epidemic.RiskAreaDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.epidemic.RiskArea;
import com.bcxin.ars.service.epidemic.RiskAreaService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RiskAreaServiceImpl
implements RiskAreaService {
    @Autowired
    private RiskAreaDao riskAreaDao;
    @Autowired
    private ArsUtil arsUtil;

    public void search(RiskAreaDto riskAreaDto, AjaxPageResponse<RiskArea> page) {
        this.arsUtil.setPoliceSearch((SearchDto)riskAreaDto);
        this.riskAreaDao.search(riskAreaDto, page);
    }

    public RiskArea findById(Long id) {
        return this.riskAreaDao.findById(id);
    }

    public void save(RiskArea riskArea) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (currentUser == null) {
            throw new ArsException("\u7528\u6237\u4fe1\u606f\u7f3a\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\uff01");
        }
        if (riskArea.getId() == null) {
            riskArea.setCreateTime(new Date());
            riskArea.setAreaCode(currentUser.getPolice().getAreacode());
        }
        riskArea.setActive(Boolean.valueOf(true));
        riskArea.setUpdateBy(currentUser.getUsername());
        riskArea.setUpdateTime(new Date());
        this.riskAreaDao.save(riskArea);
    }

    public List<RiskArea> findAll() {
        return this.riskAreaDao.findAll();
    }
}

