/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.approve.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.approve.ApproveAreaProcessDao;
import com.bcxin.ars.dao.approve.ApproveLinkDao;
import com.bcxin.ars.dao.approve.ApproveLinkLevelDao;
import com.bcxin.ars.dao.approve.ApproveLinkProDetailDao;
import com.bcxin.ars.dao.approve.ApproveTempDao;
import com.bcxin.ars.dao.approve.ApproveTempLinkRelaDao;
import com.bcxin.ars.dao.approve.ApproveTempProcessDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.approve.ApproveLinkLevelDto;
import com.bcxin.ars.dto.approve.ApproveLinkProDetailDto;
import com.bcxin.ars.dto.approve.ApproveTempLinkRelaDto;
import com.bcxin.ars.dto.approve.CheckTempConfigDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.approve.ApproveAreaProcess;
import com.bcxin.ars.model.approve.ApproveLink;
import com.bcxin.ars.model.approve.ApproveLinkLevel;
import com.bcxin.ars.model.approve.ApproveLinkProDetail;
import com.bcxin.ars.model.approve.ApproveTemp;
import com.bcxin.ars.model.approve.ApproveTempLinkRela;
import com.bcxin.ars.model.approve.ApproveTempProcess;
import com.bcxin.ars.service.approve.ApproveLinkLevelService;
import com.bcxin.ars.service.util.ApprovalActivityUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.BusinessType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=ApproveLinkLevel.class, getMethodName="updateFlagForOutToIn", getImportType=ImportType.BATCH)
public class ApproveLinkLevelServiceImpl
implements ApproveLinkLevelService {
    private static final Logger logger = LoggerFactory.getLogger(ApproveLinkLevelServiceImpl.class);
    @Autowired
    private ApproveLinkLevelDao approveLinkLevelDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApproveAreaProcessDao approveAreaProcessDao;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ApproveTempDao approveTempDao;
    @Autowired
    private ApproveTempLinkRelaDao approveTempLinkRelaDao;
    @Autowired
    private ApproveTempProcessDao approveTempProcessDao;
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private ApproveLinkDao approveLinkDao;
    @Autowired
    private ApproveLinkProDetailDao approveLinkProDetailDao;

    public List<ApproveLinkLevel> findByTempLinkRelaId(Long tempLinkRelaId) {
        return this.approveLinkLevelDao.findListByTempLinkRelaId(tempLinkRelaId);
    }

    public void delete(ApproveLinkLevel approveLinkLevel) {
        User currentUser = this.arsUtil.getCurrentUser();
        ApproveLinkLevel approveLinkLeveldb = this.approveLinkLevelDao.findById(approveLinkLevel.getId());
        if (approveLinkLeveldb != null) {
            approveLinkLevel.setUpdateTime(new Date());
            approveLinkLevel.setUpdateBy(currentUser.getUsername());
            this.approveLinkLevelDao.delete(approveLinkLevel);
        }
    }

    public void saveOrUpdate(ApproveLinkLevelDto approveLinkLevelDto) {
        List approveTempCityList;
        String orgtype = approveLinkLevelDto.getOrgType();
        Long tempId = approveLinkLevelDto.getApproveTempId();
        Long tempLinkRelaId = approveLinkLevelDto.getTempLinkRelaId();
        ArrayList<ApproveTemp> allApproveTempList = new ArrayList<ApproveTemp>();
        ArrayList<ApproveTempLinkRela> allApproveTempLinkList = new ArrayList<ApproveTempLinkRela>();
        ApproveTemp curApproveTemp = new ApproveTemp();
        curApproveTemp = this.approveTempDao.findById(tempId);
        allApproveTempList.add(curApproveTemp);
        ApproveTempLinkRela curApproveTempLinkRela = this.approveTempLinkRelaDao.findById(tempLinkRelaId);
        allApproveTempLinkList.add(curApproveTempLinkRela);
        String linkType = "";
        ApproveLink approveLink = this.approveLinkDao.findById(curApproveTempLinkRela.getApproveLinkId());
        if (approveLink != null) {
            linkType = approveLink.getLinkType();
        }
        if (orgtype.equals("1") && (approveTempCityList = this.approveTempDao.findByParentTempId(tempId)) != null && approveTempCityList.size() > 0) {
            ArrayList<ApproveTemp> deleteApproveTempCityList = new ArrayList<ApproveTemp>();
            for (ApproveTemp approveTempCity : approveTempCityList) {
                ApproveTempLinkRela cityApproveTempLinkRela = this.approveTempLinkRelaDao.findByActiveTempAndLink(curApproveTempLinkRela.getApproveLinkId(), approveTempCity.getId());
                if (cityApproveTempLinkRela != null) {
                    allApproveTempLinkList.add(cityApproveTempLinkRela);
                    continue;
                }
                deleteApproveTempCityList.add(approveTempCity);
            }
            if (deleteApproveTempCityList != null && deleteApproveTempCityList.size() > 0) {
                approveTempCityList.removeAll(deleteApproveTempCityList);
            }
            if (approveTempCityList != null) {
                allApproveTempList.addAll(approveTempCityList);
            }
        }
        Police police = this.policeDao.findById(approveLinkLevelDto.getOrgId());
        List approveLinkLevelList = JSON.parseArray((String)approveLinkLevelDto.getApproveLinkLevelList(), ApproveLinkLevel.class);
        if (allApproveTempList != null && allApproveTempList.size() > 0) {
            for (int index = 0; index < allApproveTempList.size(); ++index) {
                ApproveLinkLevel approveLinkLevel;
                int i;
                Object tempLinkRelaIdChange = ((ApproveTempLinkRela)allApproveTempLinkList.get(index)).getId();
                ApproveTemp approveTempChange = (ApproveTemp)allApproveTempList.get(index);
                List approveLinkLevelLisTuretdb = this.approveLinkLevelDao.findListTureByAllApproveLinkId((Long)tempLinkRelaIdChange);
                List approveLinkLevelListdb = this.approveLinkLevelDao.findListByAllApproveLinkId((Long)tempLinkRelaIdChange);
                if (approveLinkLevelListdb.size() > 0) {
                    int flag = 0;
                    if (approveLinkLevelLisTuretdb.size() == approveLinkLevelList.size()) {
                        for (int i2 = 0; i2 < approveLinkLevelLisTuretdb.size(); ++i2) {
                            if (!StringUtil.equals((String)((ApproveLinkLevel)approveLinkLevelLisTuretdb.get(i2)).getApproveLevel(), (String)((ApproveLinkLevel)approveLinkLevelList.get(i2)).getApproveLevel())) continue;
                            ++flag;
                        }
                        if (approveLinkLevelLisTuretdb.size() == flag) break;
                    }
                    ApproveTempLinkRela approveTempLinkRela = this.approveTempLinkRelaDao.findById((Long)tempLinkRelaIdChange);
                    approveTempLinkRela.setLinkSetStatus("0");
                    approveTempLinkRela.setUpdateTime(new Date());
                    this.approveTempLinkRelaDao.update(approveTempLinkRela);
                    if (StringUtil.equals((String)approveTempChange.getApproveSetStatus(), (String)"1")) {
                        approveTempChange.setApproveSetStatus("0");
                        approveTempChange.setFailureTime(new Date());
                        approveTempChange.setUpdateTime(new Date());
                        approveTempChange.setUpdateBy("1");
                        this.approveTempDao.update(approveTempChange);
                        this.approveTempProcessDao.batchUpdateByApproveTempId(approveTempChange);
                    }
                    HashMap<String, ApproveLinkLevel> stringApproveLinkLevelMap = new HashMap<String, ApproveLinkLevel>();
                    for (ApproveLinkLevel approveLinkLevel2 : approveLinkLevelListdb) {
                        stringApproveLinkLevelMap.put(approveLinkLevel2.getApproveLevel(), approveLinkLevel2);
                    }
                    this.approveLinkLevelDao.deleteSubordinate(police.getAreacode().substring(0, 2), police.getOrgname(), (Long)tempLinkRelaIdChange);
                    this.approveLinkLevelDao.deleteApproveDetail(police.getAreacode().substring(0, 2), police.getOrgname(), (Long)tempLinkRelaIdChange);
                    for (int i3 = 0; i3 < approveLinkLevelList.size(); ++i3) {
                        ApproveLinkLevel approveLinkLevel2;
                        if (i3 == 0) {
                            approveLinkLevel2 = (ApproveLinkLevel)stringApproveLinkLevelMap.get(((ApproveLinkLevel)approveLinkLevelList.get(i3)).getApproveLevel());
                            approveLinkLevel2.setParentId(null);
                            approveLinkLevel2.setUpdateTime(new Date());
                            approveLinkLevel2.setActive(Boolean.valueOf(true));
                            stringApproveLinkLevelMap.remove(((ApproveLinkLevel)approveLinkLevelList.get(i3)).getApproveLevel());
                            ((ApproveLinkLevel)approveLinkLevelList.get(i3)).setId(approveLinkLevel2.getId());
                            this.approveLinkLevelDao.update(approveLinkLevel2);
                            this.approveAreaProcessDao.saveAreaProcessByAreacodeFailure(police.getAreacode().substring(0, 2), approveLinkLevel2.getId(), approveLinkLevel2.getApproveLevel());
                            this.approveAreaProcessDao.updateAreaProcessByAreacode(police.getAreacode().substring(0, 2), approveLinkLevel2.getId(), approveLinkLevel2.getApproveLevel());
                            continue;
                        }
                        approveLinkLevel2 = (ApproveLinkLevel)stringApproveLinkLevelMap.get(((ApproveLinkLevel)approveLinkLevelList.get(i3)).getApproveLevel());
                        approveLinkLevel2.setParentId(((ApproveLinkLevel)approveLinkLevelList.get(i3 - 1)).getId());
                        approveLinkLevel2.setUpdateTime(new Date());
                        approveLinkLevel2.setActive(Boolean.valueOf(true));
                        stringApproveLinkLevelMap.remove(((ApproveLinkLevel)approveLinkLevelList.get(i3)).getApproveLevel());
                        ((ApproveLinkLevel)approveLinkLevelList.get(i3)).setId(approveLinkLevel2.getId());
                        this.approveLinkLevelDao.update(approveLinkLevel2);
                        this.approveAreaProcessDao.saveAreaProcessByAreacodeFailure(police.getAreacode().substring(0, 2), approveLinkLevel2.getId(), approveLinkLevel2.getApproveLevel());
                        this.approveAreaProcessDao.updateAreaProcessByAreacode(police.getAreacode().substring(0, 2), approveLinkLevel2.getId(), approveLinkLevel2.getApproveLevel());
                    }
                    for (Map.Entry entry : stringApproveLinkLevelMap.entrySet()) {
                        ApproveLinkLevel approveLinkLevel3 = (ApproveLinkLevel)entry.getValue();
                        approveLinkLevel3.setUpdateTime(new Date());
                        approveLinkLevel3.setActive(Boolean.valueOf(false));
                        this.approveLinkLevelDao.delete(approveLinkLevel3);
                        this.approveAreaProcessDao.updateAreaProcessByAreacodeFailure(police.getAreacode().substring(0, 2), approveLinkLevel3.getId(), approveLinkLevel3.getApproveLevel());
                    }
                    continue;
                }
                HashMap<String, ApproveLinkLevel> stringApproveLinkLevelMap = new HashMap<String, ApproveLinkLevel>();
                for (i = 1; i <= 4; ++i) {
                    approveLinkLevel = new ApproveLinkLevel();
                    approveLinkLevel.setCreateTime(new Date());
                    approveLinkLevel.setUpdateTime(new Date());
                    approveLinkLevel.setTempLinkRelaId((Long)tempLinkRelaIdChange);
                    approveLinkLevel.setApproveLevel(String.valueOf(i));
                    approveLinkLevel.setActive(Boolean.valueOf(false));
                    this.approveLinkLevelDao.save(approveLinkLevel);
                    approveLinkLevel.setId(approveLinkLevel.getId());
                    this.approveAreaProcessDao.saveAreaProcessByAreacodeFailure(police.getAreacode().substring(0, 2), approveLinkLevel.getId(), approveLinkLevel.getApproveLevel());
                    stringApproveLinkLevelMap.put(String.valueOf(i), approveLinkLevel);
                }
                for (i = 0; i < approveLinkLevelList.size(); ++i) {
                    if (i == 0) {
                        approveLinkLevel = (ApproveLinkLevel)stringApproveLinkLevelMap.get(((ApproveLinkLevel)approveLinkLevelList.get(i)).getApproveLevel());
                        approveLinkLevel.setParentId(null);
                        approveLinkLevel.setUpdateTime(new Date());
                        approveLinkLevel.setActive(Boolean.valueOf(true));
                        ((ApproveLinkLevel)approveLinkLevelList.get(i)).setId(approveLinkLevel.getId());
                        this.approveLinkLevelDao.update(approveLinkLevel);
                        this.approveAreaProcessDao.updateAreaProcessByAreacode(police.getAreacode().substring(0, 2), approveLinkLevel.getId(), approveLinkLevel.getApproveLevel());
                        continue;
                    }
                    approveLinkLevel = (ApproveLinkLevel)stringApproveLinkLevelMap.get(((ApproveLinkLevel)approveLinkLevelList.get(i)).getApproveLevel());
                    approveLinkLevel.setParentId(((ApproveLinkLevel)approveLinkLevelList.get(i - 1)).getId());
                    approveLinkLevel.setUpdateTime(new Date());
                    approveLinkLevel.setActive(Boolean.valueOf(true));
                    ((ApproveLinkLevel)approveLinkLevelList.get(i)).setId(approveLinkLevel.getId());
                    this.approveAreaProcessDao.updateAreaProcessByAreacode(police.getAreacode().substring(0, 2), approveLinkLevel.getId(), approveLinkLevel.getApproveLevel());
                    this.approveLinkLevelDao.update(approveLinkLevel);
                }
            }
        }
        boolean isSpecial = false;
        if (StringUtils.isEmpty((CharSequence)linkType)) {
            isSpecial = true;
        } else {
            switch (linkType) {
                case "1": {
                    isSpecial = true;
                    break;
                }
                case "2": {
                    isSpecial = true;
                    break;
                }
                case "3": {
                    isSpecial = true;
                    break;
                }
                case "4": {
                    isSpecial = true;
                    break;
                }
                case "5": {
                    isSpecial = true;
                    break;
                }
            }
        }
        if (isSpecial && allApproveTempList != null && allApproveTempList.size() > 0) {
            for (int index = 0; index < allApproveTempList.size(); ++index) {
                ApproveTemp approveTempChange = (ApproveTemp)allApproveTempList.get(index);
                if (approveTempChange.getParentTempId() == null) continue;
                try {
                    this.saveMainProcess(approveTempChange);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String saveMainProcess(ApproveTemp approveTemp) throws Exception {
        Long approveTempId = approveTemp.getId();
        approveTemp = this.approveTempDao.findById(approveTempId);
        String approveTempName = approveTemp.getTempName();
        String tempCode = approveTemp.getTempCode();
        String businessTypeCode = "";
        String groupId = "";
        Config kzConfig = this.configDao.findByKey("kzzhid");
        if (kzConfig != null && StringUtil.isNotEmpty((String)kzConfig.getValue())) {
            groupId = kzConfig.getValue();
        }
        if (tempCode.contains("-")) {
            businessTypeCode = BusinessType.getBusinessType((String)tempCode.split("-")[0]);
        }
        String maxApproveLevel = this.approveTempDao.getMaxApproveLevelByApproveTempId(approveTempId);
        String configMsg = "";
        if (StringUtil.isNotEmpty((String)maxApproveLevel)) {
            User user = this.arsUtil.getCurrentUser();
            String orgtype = user.getPolice().getOrgtype();
            String superAreaCode = "";
            String superOrgtype = "";
            Long policeId = user.getPolice().getId();
            String areaCode = user.getPolice().getAreacode();
            if (orgtype.equals("1")) {
                areaCode = areaCode.substring(0, 2);
            } else if (orgtype.equals("2")) {
                areaCode = areaCode.substring(0, 4);
                superAreaCode = areaCode.substring(0, 2) + "0000";
                superOrgtype = "1";
            } else if (orgtype.equals("3")) {
                superAreaCode = areaCode.substring(0, 4) + "00";
                superOrgtype = "2";
            } else {
                superAreaCode = areaCode;
                superOrgtype = "3";
            }
            if (!orgtype.equals("1")) {
                CheckTempConfigDto checkDto = new CheckTempConfigDto();
                checkDto.setTempId(approveTempId);
                checkDto.setAreaCode(superAreaCode);
                checkDto.setOrgtype(superOrgtype);
                Long check = this.approveTempLinkRelaDao.checkTempConfigCompleteByOrgTypeAndCityCode(checkDto);
                if (check != null && check > 0L) {
                    configMsg = "\u6a21\u677f\u73af\u8282\u4e0a\u7ea7\u673a\u6784\u672a\u914d\u7f6e\u5b8c\u6210\uff01";
                    logger.info(configMsg);
                    return configMsg;
                }
            }
            List approveTempLinkRelaList = this.approveTempLinkRelaDao.findByApproveTempIdList(approveTempId);
            List policeList = new ArrayList<Police>();
            if (orgtype.equals("4")) {
                Police police = this.policeDao.findById(policeId);
                policeList.add(police);
            } else {
                policeList = this.policeDao.findPoliceByOrgTypeAndLikeAreacode(maxApproveLevel, areaCode);
            }
            if (policeList != null && policeList.size() > 0) {
                ArrayList<ApproveTempProcess> approveTempProcessList = new ArrayList<ApproveTempProcess>();
                for (Police police : policeList) {
                    String[] policeIds = police.getPath().split("/");
                    ApproveLinkProDetailDto searchDto = new ApproveLinkProDetailDto();
                    searchDto.setPoliceIds(policeIds);
                    ArrayList<ApproveTempLinkRelaDto> approveTempLinkRelaDtoList = new ArrayList<ApproveTempLinkRelaDto>();
                    if (approveTempLinkRelaList == null || approveTempLinkRelaList.size() <= 0) continue;
                    int tempLinkSize = approveTempLinkRelaList.size();
                    for (ApproveTempLinkRela approveTempLinkRela : approveTempLinkRelaList) {
                        ApproveTempLinkRelaDto approveTempLinkRelaDto;
                        Long tempLinkRelaId = approveTempLinkRela.getId();
                        String approveLevel = this.approveLinkLevelDao.getMaxApproveLevelByTempLinkRelaId(tempLinkRelaId);
                        if (StringUtil.isEmpty((String)approveLevel)) {
                            ApproveLink approveLink = this.approveLinkDao.findById(approveTempLinkRela.getApproveLinkId());
                            if (approveLink == null) continue;
                            if (StringUtils.isEmpty((CharSequence)approveLink.getLinkType())) {
                                configMsg = "\u5ba1\u6279\u6d41\u7a0b\u672a\u542f\u52a8\uff1a\u5b58\u5728\u672a\u914d\u7f6e\u5ba1\u6279\u5355\u4f4d\u7684\u5ba1\u6279\u73af\u8282";
                                return configMsg;
                            }
                            approveTempLinkRelaDto = new ApproveTempLinkRelaDto();
                            approveTempLinkRelaDto.setLinkName(approveLink.getLinkName());
                            approveTempLinkRelaDto.setLinkType(approveLink.getLinkType());
                            approveTempLinkRelaDtoList.add(approveTempLinkRelaDto);
                            continue;
                        }
                        searchDto.setTempLinkRelaId(tempLinkRelaId);
                        searchDto.setApproveLevel(approveLevel);
                        ApproveLinkProDetail pproveLinkProDetail = this.approveLinkProDetailDao.findListByTempLinkRelaIdAndPoliceIds(searchDto);
                        if (pproveLinkProDetail == null) break;
                        approveTempLinkRelaDto = new ApproveTempLinkRelaDto();
                        approveTempLinkRelaDto = this.approveTempLinkRelaDao.findDtoById(pproveLinkProDetail.getTempLinkRelaId());
                        approveTempLinkRelaDto.setApproveLinkProDetailId(pproveLinkProDetail.getId());
                        approveTempLinkRelaDto.setApproveAreaProId(pproveLinkProDetail.getApproveAreaProId());
                        approveTempLinkRelaDtoList.add(approveTempLinkRelaDto);
                    }
                    if (approveTempLinkRelaDtoList == null || approveTempLinkRelaDtoList.size() <= 0 || tempLinkSize != approveTempLinkRelaDtoList.size()) continue;
                    if (businessTypeCode.equals("008")) {
                        ArrayList<ApproveAreaProcess> approveAreaProcessList = new ArrayList<ApproveAreaProcess>();
                        ApproveAreaProcess approveAreaProcess = this.approveAreaProcessDao.findById(((ApproveTempLinkRelaDto)approveTempLinkRelaDtoList.get(approveTempLinkRelaDtoList.size() - 1)).getApproveAreaProId());
                        if (approveAreaProcess != null) {
                            approveAreaProcessList.add(approveAreaProcess);
                        }
                        if (approveTempLinkRelaDtoList.size() > 1 && (approveAreaProcess = this.approveAreaProcessDao.findById(((ApproveTempLinkRelaDto)approveTempLinkRelaDtoList.get(approveTempLinkRelaDtoList.size() - 2)).getApproveAreaProId())) != null) {
                            approveAreaProcessList.add(approveAreaProcess);
                        }
                        ApprovalActivityUtil.thirdJsonUpdate(approveAreaProcessList);
                    }
                    ApproveTempProcess approveTempProcess = new ApproveTempProcess();
                    approveTempProcess.setCreateTime(new Date());
                    approveTempProcess.setUpdateTime(new Date());
                    approveTempProcess.setActive(Boolean.valueOf(true));
                    approveTempProcess.setApproveTempId(approveTempId);
                    approveTempProcess.setRegionLevel(police.getOrgtype());
                    approveTempProcess.setPoliceCode(StringUtil.isNotEmpty((String)police.getCode()) ? police.getCode().toString() : "");
                    approveTempProcess.setPoliceId(police.getId());
                    String processID = tempCode + "-" + police.getId().toString();
                    String processName = approveTempName + police.getOrgname();
                    approveTempProcess.setProcessInfo(ApprovalActivityUtil.oneJson(approveTempLinkRelaDtoList, processID, processName, groupId));
                    approveTempProcessList.add(approveTempProcess);
                }
                if (approveTempProcessList != null && approveTempProcessList.size() > 0) {
                    this.approveTempProcessDao.batchSave(approveTempProcessList);
                    ApproveTemp approveTempSave = this.approveTempDao.findById(approveTempId);
                    approveTempSave.setEffectTime(new Date());
                    approveTempSave.setUpdateTime(new Date());
                    approveTempSave.setApproveSetStatus("1");
                    this.approveTempDao.update(approveTempSave);
                }
            } else if (approveTempLinkRelaList != null && approveTempLinkRelaList.size() > 0) {
                for (ApproveTempLinkRela approveTempLinkRela : approveTempLinkRelaList) {
                    ApproveLink approveLink;
                    Long tempLinkRelaId = approveTempLinkRela.getId();
                    String approveLevel = this.approveLinkLevelDao.getMaxApproveLevelByTempLinkRelaId(tempLinkRelaId);
                    if (!StringUtil.isEmpty((String)approveLevel) || (approveLink = this.approveLinkDao.findById(approveTempLinkRela.getApproveLinkId())) == null || !StringUtils.isEmpty((CharSequence)approveLink.getLinkType())) continue;
                    configMsg = "\u5ba1\u6279\u6d41\u7a0b\u672a\u542f\u52a8\uff1a\u5b58\u5728\u672a\u914d\u7f6e\u5ba1\u6279\u5355\u4f4d\u7684\u5ba1\u6279\u73af\u8282";
                    return configMsg;
                }
            }
        } else {
            configMsg = "\u5ba1\u6279\u73af\u8282\u672a\u914d\u7f6e";
        }
        return configMsg;
    }

    public ApproveLinkLevel findById(Long approveLinkLevelId) {
        return this.approveLinkLevelDao.findById(approveLinkLevelId);
    }

    public List<ApproveLinkLevel> findListTureByApproveLinkIdAndLevel(Long tempLinkRelaId, String approveLevel) {
        return this.approveLinkLevelDao.findListTureByApproveLinkIdAndLevel(tempLinkRelaId, approveLevel);
    }

    public void insertBatchTemp(List<ApproveLinkLevel> approveList) {
        this.approveLinkLevelDao.insertBatchTemp(approveList);
    }

    public List<ApproveLinkLevel> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.approveLinkLevelDao.searchForDataSynchronization(searchDto);
    }

    public void updateFlagForOutToIn(List<ApproveLinkLevel> linkLevelList) {
        this.approveLinkLevelDao.updateFlagForOutToIn(linkLevelList);
    }
}

