/*
 * Decompiled with CFR 0.152.
 */
package com.com.bcxin.ars.com.abcxin.smart.core.web.validate;

import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.ResponseCode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.RowBounds;

public class AjaxPageResponse<T extends Serializable>
extends RowBounds
implements Serializable,
Cloneable {
    private String code;
    private String message;
    private List<T> data;
    private int pageNumber = 1;
    private int pageSize = 20;
    private long total = 0L;
    private long totalPage = 0L;
    private boolean pagination = true;
    private String sort;
    private String order;
    private Map userData = Maps.newHashMap();

    public AjaxPageResponse() {
        this(ResponseCode.SUCCESS, "\u64cd\u4f5c\u6210\u529f");
    }

    public AjaxPageResponse(String code) {
        this(code, null);
    }

    public AjaxPageResponse(String code, String message) {
        this.code = code == null ? ResponseCode.SUCCESS : code;
        this.message = message;
        if (this.message == null) {
            if (code.equals(ResponseCode.SUCCESS)) {
                this.message = "\u64cd\u4f5c\u6210\u529f";
            }
            if (code.equals(ResponseCode.FAIL)) {
                this.message = "\u64cd\u4f5c\u5931\u8d25";
            }
            if (code.equals(ResponseCode.UNAUTHORIZED)) {
                this.message = "\u7528\u6237\u9a8c\u8bc1\u5931\u8d25";
            }
        }
        this.data = Lists.newArrayList();
    }

    public static AjaxPageResponse fail() {
        return AjaxPageResponse.fail(null);
    }

    public static AjaxPageResponse fail(String message) {
        return new AjaxPageResponse(ResponseCode.FAIL, message);
    }

    public static AjaxPageResponse success() {
        return AjaxPageResponse.success(null);
    }

    public static AjaxPageResponse success(String message) {
        return new AjaxPageResponse(ResponseCode.SUCCESS, message);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List getData() {
        return this.data;
    }

    public void setData(List data) {
        this.data = data;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
        this.totalPage = this.total / (long)this.getPageSize();
        if (this.total % (long)this.getPageSize() != 0L) {
            ++this.totalPage;
        }
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(long totalPage) {
        this.totalPage = totalPage;
    }

    public Map getUserData() {
        return this.userData;
    }

    public void setUserData(Map userData) {
        this.userData = userData;
    }

    public boolean isPagination() {
        return this.pagination;
    }

    public void setPagination(boolean pagination) {
        this.pagination = pagination;
    }

    public AjaxPageResponse clone() throws CloneNotSupportedException {
        return (AjaxPageResponse)super.clone();
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }
}

