package com.bcxin.sync.apis.responses;
import com.bcxin.runtime.domain.metas.entities.enums.FormType;
import lombok.Getter;
import java.util.Collection;

@Getter
public class FormSyncMetaResponse {
    private final Collection<FormSync> formSyncs;

    public FormSyncMetaResponse(Collection<FormSync> formSyncs) {
        this.formSyncs = formSyncs;
    }

    @Getter
    public static class FormSync {
        private final String id;
        private final String appId;
        private final String formId;
        private final String note;
        private final String config;
        private final FormType formType;
        private final String targetId;
        private final boolean isOnline;

        public FormSync(String id, String appId, String formId,boolean isOnline,
                        String note,
                        String config, FormType formType,
                        String targetId) {
            this.id = id;
            this.appId = appId;
            this.formId = formId;
            this.note = note;
            this.config = config;
            this.formType = formType;
            this.targetId = targetId;
            this.isOnline = isOnline;
        }

        public static FormSync create(String id, String appId, String formId, boolean isOnline, String note,
                                      FormType formType, String config,String targetId) {
            return new FormSync(id, appId, formId, isOnline, note, config, formType,targetId);
        }
    }

    public static FormSyncMetaResponse create(Collection<FormSync> formSyncs) {
        return new FormSyncMetaResponse(formSyncs);
    }
}
