package com.bcxin.sync.apis.requests;
import com.bcxin.runtime.domain.syncs.commands.CreateDataSyncCommand;
import com.bcxin.runtime.domain.syncs.commands.CreateFtpDataSyncCommand;
import com.bcxin.saas.core.components.JsonProvider;
import lombok.Data;
import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

@Data
public class SyncViaFtpDataImportRequest extends RequestAbstract{
    private String data;
    private String businessType;
    private String filePaths;
    private Map urlFilePathMappings;

    public CreateFtpDataSyncCommand getCommand(JsonProvider jsonProvider) {
        SyncViaDirectlyDbDataImportRequest dataImportRequest = null;
        try {
            dataImportRequest = jsonProvider.getData(this.getData(), SyncViaDirectlyDbDataImportRequest.class);
        }catch (Exception e){
            String jsonData = StringEscapeUtils.unescapeJava(this.getData());
            dataImportRequest = jsonProvider.getData(jsonData, SyncViaDirectlyDbDataImportRequest.class);
        }
        Collection<CreateDataSyncCommand.DataSet> ds =
                dataImportRequest.getDataSets().stream().map(ii -> {
                    return CreateDataSyncCommand.DataSet
                            .create(ii.getId(), ii.getMapKey(),
                                    ii.getDataRecords(), ii.getDeletedIds());
                }).collect(Collectors.toList());

        String filePaths = this.getFilePaths();
        Map urlFilePathMappings = this.urlFilePathMappings;
        if (!StringUtils.hasLength(filePaths)) {
            filePaths = dataImportRequest.getFilePaths();
            urlFilePathMappings = dataImportRequest.getUrlFilePathMappings();
        }

        return CreateFtpDataSyncCommand.create(ds, this.getBusinessType(), filePaths, urlFilePathMappings);
    }

    @Override
    public void validate() {
        Assert.hasLength(this.data,"data不能为空!");
        Assert.hasLength(this.businessType,"businessType不能为空!");
    }
}
