package com.bcxin.sync.apis.requests;

import com.bcxin.runtime.domain.syncs.commands.CreateSyncFileCommand;
import com.bcxin.runtime.domain.syncs.dtos.FileItemRequestDto;
import com.bcxin.saas.core.exceptions.SaasBadException;
import lombok.Data;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;

@Data
public class SyncViaDirectlyFileDataImportRequest extends RequestAbstract {
    private Collection<FileItemRequestDto> fileItems;
    private String id;

    public CreateSyncFileCommand getCommand() {
        return CreateSyncFileCommand.create(id, fileItems);
    }

    @Override
    public void validate() {
        Assert.notEmpty(this.fileItems, "fileItems文件列表不能为空!");
        Assert.hasLength(this.id, "id不能为空!");
    }
}
