package com.bcxin.sync.apis.requests;

import com.bcxin.runtime.domain.metas.commands.RefreshFormSyncTargetMetaCommand;
import com.bcxin.runtime.domain.snapshoots.enums.SyncTargetType;
import com.bcxin.saas.core.enums.HttpMethod;
import lombok.Data;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

@Data
public class FormSyncTargetRequest {
    public Collection<TargetItem> targets;

    public RefreshFormSyncTargetMetaCommand getCommand() {
        Collection<RefreshFormSyncTargetMetaCommand.FormSyncTargetMeta> targetMetas =
                this.getTargets().stream()
                        .map(ii -> {
                            return
                                    RefreshFormSyncTargetMetaCommand.FormSyncTargetMeta.create(ii.getCode(),
                                            ii.getTargetType(),
                                            ii.getUrl(),ii.getFileUploadUrl(),
                                            ii.getMethod(), ii.getHeaders(), ii.getBodyAdditionalData()
                                    );
                        }).collect(Collectors.toList());

        RefreshFormSyncTargetMetaCommand command = new RefreshFormSyncTargetMetaCommand(targetMetas);

        return command;
    }

    @Data
    public static class TargetItem
    {
        private String code;
        private HttpMethod method;
        private String url;
        private Map<String, Object> headers;
        private Map<String, Object> bodyAdditionalData;
        private String fileUploadUrl;
        private SyncTargetType targetType;

        public TargetItem(){}

        public TargetItem(SyncTargetType targetType,String code, HttpMethod method, String url,
                          String fileUploadUrl,Map<String,Object> headers,Map<String,Object> bodyAdditionalData) {
            this.setUrl(url);
            this.setCode(code);
            this.setTargetType(targetType);
            this.setHeaders(headers);
            this.setBodyAdditionalData(bodyAdditionalData);
            this.setMethod(method);
            this.setFileUploadUrl(fileUploadUrl);
        }

    }
}
