package com.bcxin.sync.apis.requests;

import com.bcxin.runtime.domain.metas.commands.CreateFormSyncMetaCommand;
import com.bcxin.runtime.domain.snapshoots.FormSyncConfigSnapshot;
import lombok.Data;

import java.util.Collection;
import java.util.stream.Collectors;

@Data
public class FormSyncRequest {
    private Collection<FormSync> formSyncs;

    @Data
    public static class FormSync {
        private String appId;
        private String formId;
        private String note;
        private FormSyncConfigSnapshot config;
        private String targetId;
        public boolean online;
    }

    public CreateFormSyncMetaCommand getCommand() {
        Collection<CreateFormSyncMetaCommand.FormSync> datas =
                this.getFormSyncs().stream().map(ii ->
                        CreateFormSyncMetaCommand.FormSync.create(ii.getAppId(),
                                ii.getFormId(),ii.getConfig(),
                                ii.isOnline(), ii.getNote(),
                                ii.getTargetId()))
                        .collect(Collectors.toList());

        return CreateFormSyncMetaCommand.create(datas);
    }
}
