package com.bcxin.sync.apis.controllers;

import cn.hutool.core.util.StrUtil;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.util.ftp.FtpUtils;
import com.bcxin.sync.apis.configs.FileModeConfig;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;


@Controller
@Slf4j
@RequestMapping("/api/runtime")
public class FileController {
	
	private Logger logger = LoggerFactory.getLogger(FileController.class);

    /****
     * 判断字符串是否为日期格式
     * @param str
     * @return
     */
    public static boolean isValidDate(String str) {
        boolean convertSuccess=true;
        // 指定日期格式为四位年/两位月份/两位日期，注意yyyy/MM/dd区分大小写；
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            // 设置lenient为false. 否则SimpleDateFormat会比较宽松地验证日期，比如2007/02/29会被接受，并转换成2007/03/01
            format.setLenient(false);
            format.parse(str);
        } catch (ParseException e) {
            // e.printStackTrace();
            // 如果throw java.text.ParseException或者NullPointerException，就说明格式不对
            convertSuccess=false;
        }
        return convertSuccess;

    }

	/***
	 * 过滤非法字符
	 * @param str
	 * @return
	 * @throws PatternSyntaxException
	 */
	public   static   boolean StringFilter(String   str)   throws PatternSyntaxException {
		boolean resulst = true;
		String regEx = "[ `~!@#$%^&*()+=|{}':;',\\[\\]<>?~！@#￥%……&*（）—+|{}【】‘；：”“’。，、？]|\n|\r|\t";
		//不允许..
		if(str.indexOf("..")>0){
			resulst =false;
		}
		//非法字符
		Pattern p = Pattern.compile(regEx);
		Matcher m = p.matcher(str);

		if(m.find()){
			resulst = false;
		}
		return  resulst;
	}
	/***
	 * 时间戳转日期类型
	 * @param seconds
	 * @return
	 */
	public static boolean timeStampDate(String seconds) {
		boolean convertSuccess=true;
		try {
			if(seconds == null || seconds.isEmpty() || seconds.equals("null")){
				return false;
			}
			String format="yyyy-MM-dd";
			SimpleDateFormat sdf = new SimpleDateFormat(format);
			sdf.format(new Date(Long.valueOf(seconds+"000")));
		} catch (Exception e) {
			// e.printStackTrace();
			// 如果throw java.text.ParseException或者NullPointerException，就说明格式不对
			convertSuccess=false;
		}
		return convertSuccess;
	}
    /**
     * 下载文件
     * @param path
     * @param response
     * @throws IOException
     */
    @RequestMapping("/getResource")
    public void getResource(String path, HttpServletResponse response) throws Exception {
        File file = null;
        InputStream is = null;
        ServletOutputStream out = null;
        String suffix = path.substring(path.lastIndexOf(".") + 1);
        //ftp只能取图片，zip或rar从硬盘取
        String fileTypes = "ZIP,RAR";
        if(FileModeConfig.getUseFtp() && path.startsWith("upload")){
            String[] paths =  path.split("/");
            if(paths.length!=3){
                throw new Exception("系统错误！！！");
            }
            try {
                //文件路径
                String filePath = path.substring(0, path.lastIndexOf("/") + 1);
                //文件名称
                String fileName = path.substring(path.lastIndexOf("/") + 1);
                String tempPath = PropertyUtil.getPath() + "/temp/";
                File tempFile = FtpUtils.downloadFile(FileModeConfig.getHost(),
                        FileModeConfig.getUserName(),
                        FileModeConfig.getPassword(),
                        FileModeConfig.getPort(),
                        (StrUtil.isEmpty(FileModeConfig.getFilePath()) ? "":FileModeConfig.getFilePath()) + filePath,
                        tempPath,
                        fileName);


                is = new FileInputStream(tempFile);
                out = response.getOutputStream();
                fileName = new String(fileName.getBytes("UTF-8"), "iso-8859-1");
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                int read = 0;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                tempFile.delete();
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                throw new Exception("文件"+path+"不存在！！！");
            } finally {
                if (is != null) {
                    is.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
        }else{
            if(path.startsWith("upload")) {
                file = new File(PropertyUtil.getPath() + path);
            } else if(path.startsWith("temp")) {
                file = new File(PropertyUtil.getPath() + path);
            }  else if(path.startsWith("pdf")) {
                file = new File(PropertyUtil.getPath() + path);
            }else if(path.startsWith("sysAttachment")) {
                file = new File(PropertyUtil.getPath() + path);
            }else if(path.startsWith("approveAttachment")) {
                file = new File(PropertyUtil.getPath() + path);
            }else if(path.startsWith("personImg")) {
                file = new File(PropertyUtil.getPath() + path);
            }else{
                throw new Exception("系统错误！！！");
            }
            logger.info("文件路径： " + file.getPath());
            //判断是否为三段式，不是三段式则有问题路径
            String[] paths =  path.split("/");
            if(paths.length!=3){
                throw new Exception("系统错误！！！");
            }else{
                //判断第二段是否为日期
                if(!isValidDate(paths[1])) {
                    throw new Exception("系统错误！！！");
                }
                String fileType = paths[2];
                String[] temp =fileType.split("\\.");
                if(temp.length!=2){
                    throw new Exception("系统错误！！！");
                }
                //文件类型判断
                if(!StringFilter(fileType)){
                    throw new Exception("系统错误！！！");
                }
            }
            if(file != null) {
                try {
                    out = response.getOutputStream();
                    String fileName = new String(file.getName().getBytes("UTF-8"),"iso-8859-1");
                    response.addHeader("Content-Disposition","attachment;filename=" + fileName);
                    is = new FileInputStream(file);
                    int read = 0;
                    byte[] buffer = new byte[8192];
                    while ((read = is.read(buffer)) != -1) {
                        out.write(buffer, 0, read);
                    }
                }catch (Exception e ){
                    logger.error(e.getMessage(),e);
                }finally {
                    if(is!=null){
                        is.close();
                    }
                    if(out!=null){
                        out.flush();
                        out.close();
                    }
                }
            }
        }
    }

}
