package com.bcxin.runtime.apis.components;
import cn.myapps.common.dao.JDBCUtil;
import com.alibaba.druid.util.JdbcUtils;
import com.bcxin.runtime.apis.dtos.ChangeLogContext;
import com.bcxin.runtime.domain.constants.FieldNames;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

public interface MappingSqlValueTranslator {
    String get(ChangeLogContext logContext, String sqlFormat, String key, Object originalValue);

    @Component
    public static class MappingSqlValueTranslatorImpl implements MappingSqlValueTranslator {
        @Override
        public String get(ChangeLogContext logContext, String sqlFormat, String key, Object originalValue) {
            String colPlaceHolder = "\\#\\{" + String.valueOf(key) + "\\}";
            String colPlaceHolder2 = "\\#\\{item_" + String.valueOf(key) + "\\}";
            Object colValue = originalValue;
            try {
                if (colValue == null) {
                    colPlaceHolder = String.format("'%s'", colPlaceHolder);
                    colPlaceHolder2 = String.format("'%s'", colPlaceHolder2);
                    colValue = "NULL";
                    /**
                     * 判断是否为附件信息
                     */
                } else {
                    String pathFieldExpress = String.format("#{path:%s}", key);
                    if (FieldNames.isFile(String.valueOf(key)) || sqlFormat.contains(pathFieldExpress)) {
                        //paths.add(String.valueOf(colValue));
                        //对数据进行格式化操作
                        colValue = FieldNames.formattedFileValue("", "manually", "manually", String.valueOf(colValue));
                    }
                }

                if(key.equalsIgnoreCase(ChangeLogContext.ISTMP_COLUMN))
                {
                    String isTmpValue = getValue(colValue);
                    if(StringUtils.hasLength(isTmpValue)) {
                        isTmpValue = isTmpValue.replace("'", "");
                    }

                    sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", colPlaceHolder), isTmpValue);
                    sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", colPlaceHolder2), isTmpValue);
                }else {
                    sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", colPlaceHolder), getValue(colValue));
                    sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", colPlaceHolder2), getValue(colValue));
                }

                return sqlFormat;
            } catch (Exception ex) {
                sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", colPlaceHolder), getValue(ex.getMessage()));
                sqlFormat = sqlFormat.replaceAll(String.format("(?i)%s", colPlaceHolder2), getValue(ex.getMessage()));
            }

            return sqlFormat;
        }

        private String getValue(Object value) {
            if (value == null) {
                return String.valueOf(value);
            }

            return JDBCUtil.toSqlStringValue(value);
        }
    }
}
