package com.bcxin.event.entities;

import com.bcxin.event.enums.EventAction;
import com.bcxin.saas.core.models.EntityBase;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;

@Getter
@Setter(AccessLevel.PROTECTED)
@Entity
@Table(name = "data_event_sources")
public class EventSourceEntity extends EntityBase<String> {
    @Id
    @Column(length = 50)
    private String id;
    @Column(nullable = false, length = 50, name = "record_id")
    private String recordId;
    @Column(name = "meta_id", length = 50, nullable = false)
    private String metaId;
    //@Lob
    private String data;
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "last_updated_time")
    private Date lastUpdatedTime;
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "created_time", nullable = false)
    private Date createdTime;

    @Enumerated(EnumType.ORDINAL)
    @Column(name = "event_action", nullable = false)
    private EventAction eventAction;

    protected EventSourceEntity()
    {

    }
    public static EventSourceEntity create(EventAction eventAction,
                                           String recordId, String metaId,
                                           String data) {
        EventSourceEntity eventSourceEntity = new EventSourceEntity();
        eventSourceEntity.setEventAction(eventAction);
        eventSourceEntity.setData(data);
        eventSourceEntity.setMetaId(metaId);
        eventSourceEntity.setRecordId(recordId);
        eventSourceEntity.setCreatedTime(new Date());
        eventSourceEntity.setId(String.format("%s%s", (new SimpleDateFormat("yyyyMMddhhmmss").format(new Date())),
                UUID.randomUUID().toString()));

        return eventSourceEntity;
    }
}