package com.bcxin.event.commands;

import com.bcxin.event.enums.EventAction;
import lombok.Getter;

@Getter
public class CreateEventSourceRecordCommand {
    private final String recordId;
    private final String metaId;
    private final Object data;
    private final EventAction eventAction;

    public CreateEventSourceRecordCommand(EventAction eventAction, String recordId, String metaId, Object data) {
        this.recordId = recordId;
        this.metaId = metaId;
        this.data = data;
        this.eventAction = eventAction;
    }

    public static CreateEventSourceRecordCommand create(EventAction eventAction, String recordId, String metaId, Object data) {
        return new CreateEventSourceRecordCommand(eventAction, recordId, metaId, data);
    }
}
