/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.web.commons.components;

import com.bcxin.saas.core.components.SecondCacheProvider;
import com.bcxin.saas.core.components.ThreadContextManager;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component
@Primary
public class SecondCacheProviderRequestAttributeImpl
implements SecondCacheProvider {
    private static final Logger logger = LoggerFactory.getLogger(SecondCacheProviderRequestAttributeImpl.class);
    private final ThreadContextManager threadContextManager;

    public SecondCacheProviderRequestAttributeImpl(ThreadContextManager threadContextManager) {
        this.threadContextManager = threadContextManager;
    }

    public <T> T getData(String key, Supplier<T> supplier) {
        Object result = this.threadContextManager.get(key);
        if (result == null) {
            result = supplier.get();
            this.threadContextManager.store(key, result);
        }
        return (T)result;
    }

    public void removeData(String key) {
        this.threadContextManager.remove(key);
    }

    public <T> T getIfPresent(String key) {
        return (T)this.threadContextManager.get(key);
    }

    public <T> void setData(String key, T data) {
        this.threadContextManager.store(key, data);
    }

    public boolean isWebRequest() {
        try {
            return this.threadContextManager.isWebRequest();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void clear() {
        try {
            this.threadContextManager.clear();
        }
        catch (Exception ex) {
            logger.error("clear \u53d1\u751f\u5f02\u5e38", (Throwable)ex);
        }
    }
}

