package com.bcxin.rbac.apis.impls;

import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.rbacs.RbacUserRpcProvider;
import com.bcxin.api.interfaces.rbacs.requests.AssignUserRequest;
import com.bcxin.api.interfaces.rbacs.responses.RoleDetailGetResponse;
import com.bcxin.api.interfaces.rbacs.responses.UserDetailGetResponse;
import com.bcxin.rbac.domain.RbacDbReader;
import com.bcxin.rbac.domain.dtos.RoleDetailDto;
import com.bcxin.rbac.domain.dtos.UserDetailDto;
import com.bcxin.rbac.domain.services.UserService;
import com.bcxin.rbac.domain.services.commands.users.AssignUserCommand;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.util.CollectionUtils;
import java.util.stream.Collectors;

@DubboService(version = ApiConstant.VERSION,validation = "true",timeout = 30 *1000,retries = 0)
public class RbacUserRpcProviderImpl implements RbacUserRpcProvider {
    private final UserService userService;
    private final RbacDbReader dbReader;

    public RbacUserRpcProviderImpl(UserService userService, RbacDbReader dbReader) {
        this.userService = userService;
        this.dbReader = dbReader;
    }


    @Override
    public void assign(String refSubjectId,AssignUserRequest request) {
        this.userService.dispatch(AssignUserCommand.create(
                refSubjectId,
                request.getItems().stream().map(ix ->
                        AssignUserCommand.UserCommandItem.create(ix.getReferencedId(), ix.getName(), ix.getRoleIds())).collect(Collectors.toList()))
        );
    }

    @Override
    public UserDetailGetResponse getById(String refSubjectId, String id) {
        UserDetailDto userDetailDto = this.dbReader.getUserDetailById(refSubjectId, id);
        if (userDetailDto == null) {
            throw new NotFoundTenantException("找不到资源信息");
        }

        UserDetailGetResponse userDetailGetResponse =
                UserDetailGetResponse.create(userDetailDto.getId(), userDetailDto.getReferencedId(), userDetailDto.getName());
        for (RoleDetailDto roleDetailDto : userDetailDto.getRoleDetails()) {
            RoleDetailGetResponse detailGetResponse = RoleDetailGetResponse.create(roleDetailDto.getId(), roleDetailDto.getName());
            for (RoleDetailDto.RoleSelectedResourceDto selectedResourceDto : roleDetailDto.getResources()) {
                RoleDetailGetResponse.ResourceItem dataItem =
                        RoleDetailGetResponse.ResourceItem.create(selectedResourceDto.getId(), selectedResourceDto.getCode(), selectedResourceDto.getName());

                detailGetResponse.assignResourceItem(dataItem);

                buildRoleSelectedResourceDto(dataItem, selectedResourceDto);
            }

            userDetailGetResponse.assignRoleDetail(detailGetResponse);
        }

        return userDetailGetResponse;
    }

    private void buildRoleSelectedResourceDto(RoleDetailGetResponse.ResourceItem dataItem, RoleDetailDto.RoleSelectedResourceDto resourceDto) {
        if (CollectionUtils.isEmpty(resourceDto.getChildren())) {
            return;
        }

        for (RoleDetailDto.RoleSelectedResourceDto rt : resourceDto.getChildren()) {
            RoleDetailGetResponse.ResourceItem rtNewItem =
                    RoleDetailGetResponse.ResourceItem.create(rt.getId(), rt.getCode(), rt.getName());
            this.buildRoleSelectedResourceDto(rtNewItem, rt);

            dataItem.assignResourceItem(rtNewItem);
        }
    }

}
