package com.bcxin.rbac.apis.impls;

import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.rbacs.RbacRoleRpcProvider;
import com.bcxin.api.interfaces.rbacs.requests.CreateRoleRequest;
import com.bcxin.api.interfaces.rbacs.requests.UpdateRoleRequest;
import com.bcxin.api.interfaces.rbacs.responses.RoleDetailGetResponse;
import com.bcxin.api.interfaces.rbacs.responses.RoleGetResponse;
import com.bcxin.rbac.domain.RbacDbReader;
import com.bcxin.rbac.domain.dtos.RoleDetailDto;
import com.bcxin.rbac.domain.services.RoleService;
import com.bcxin.rbac.domain.services.commands.roles.CreateRoleCommand;
import com.bcxin.rbac.domain.services.commands.roles.DeleteRoleCommand;
import com.bcxin.rbac.domain.services.commands.roles.ResourceItem;
import com.bcxin.rbac.domain.services.commands.roles.UpdateRoleCommand;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.stream.Collectors;

@DubboService(version = ApiConstant.VERSION,validation = "true",timeout = 30 *1000,retries = 0)
public class RbacRoleRpcProviderImpl implements RbacRoleRpcProvider {
    private final RoleService roleService;
    private final RbacDbReader dbReader;

    public RbacRoleRpcProviderImpl(RoleService roleService, RbacDbReader dbReader) {
        this.roleService = roleService;
        this.dbReader = dbReader;
    }

    @Override
    public void create(String refSubjectId, CreateRoleRequest request) {
        this.roleService.dispatch(CreateRoleCommand.create(refSubjectId,
                request.getName(),
                request.getResources().stream().map(ix -> ResourceItem.create(ix.getCategoryId(), ix.getResourceIds())).collect(Collectors.toList()))
        );
    }

    @Override
    public void update(String refSubjectId, String id, UpdateRoleRequest request) {
        this.roleService.dispatch(UpdateRoleCommand.create(id, request.getName(),
                request.getResources().stream().map(ix -> ResourceItem.create(ix.getCategoryId(), ix.getResourceIds())).collect(Collectors.toList()))
        );
    }

    @Override
    public void delete(String refSubjectId, String id) {
        this.roleService.dispatch(DeleteRoleCommand.create(id));
    }

    @Override
    public Collection<RoleGetResponse> getAll(String refSubjectId) {
        return this.dbReader.getAllRoles(refSubjectId)
                .stream().map(ii -> RoleGetResponse.create(ii.getId(), ii.getName())).collect(Collectors.toList());
    }

    @Override
    public RoleDetailGetResponse getById(String refSubjectId, String id) {
        RoleDetailDto roleDetailDto = this.dbReader.getRoleById(refSubjectId, id);
        if (roleDetailDto == null) {
            throw new NotFoundTenantException("找不到数据");
        }

        RoleDetailGetResponse detailGetResponse = RoleDetailGetResponse.create(roleDetailDto.getId(), roleDetailDto.getName());
        for (RoleDetailDto.RoleSelectedResourceDto selectedResourceDto : roleDetailDto.getResources()) {
            RoleDetailGetResponse.ResourceItem dataItem =
                    RoleDetailGetResponse.ResourceItem.create(selectedResourceDto.getId(), selectedResourceDto.getCode(), selectedResourceDto.getName());

            detailGetResponse.assignResourceItem(dataItem);

            buildRoleSelectedResourceDto(dataItem, selectedResourceDto);
        }

        return detailGetResponse;
    }

    private void buildRoleSelectedResourceDto(RoleDetailGetResponse.ResourceItem dataItem, RoleDetailDto.RoleSelectedResourceDto resourceDto) {
        if (CollectionUtils.isEmpty(resourceDto.getChildren())) {
            return;
        }

        for (RoleDetailDto.RoleSelectedResourceDto rt : resourceDto.getChildren()) {
            RoleDetailGetResponse.ResourceItem rtNewItem =
                    RoleDetailGetResponse.ResourceItem.create(rt.getId(), rt.getCode(), rt.getName());
            this.buildRoleSelectedResourceDto(rtNewItem, rt);

            dataItem.assignResourceItem(rtNewItem);
        }
    }
}
