package com.bcxin.rbac.apis.impls;

import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.rbacs.RbacResourceRpcProvider;
import com.bcxin.api.interfaces.rbacs.requests.ResourceRequest;
import com.bcxin.api.interfaces.rbacs.responses.ResourceGetResponse;
import com.bcxin.rbac.domain.RbacDbReader;
import com.bcxin.rbac.domain.dtos.ResourceDto;
import com.bcxin.rbac.domain.services.ResourceService;
import com.bcxin.rbac.domain.services.commands.resources.CreateResourceCommand;
import com.bcxin.rbac.domain.services.commands.resources.DeleteResourceCommand;
import com.bcxin.rbac.domain.services.commands.resources.UpdateResourceCommand;
import org.apache.dubbo.config.annotation.DubboService;

import java.util.Collection;
import java.util.stream.Collectors;

@DubboService(version = ApiConstant.VERSION,validation = "true",timeout = 30 *1000,retries = 0)
public class RbacResourceRpcProviderImpl implements RbacResourceRpcProvider {
    private final ResourceService resourceService;
    private final RbacDbReader dbReader;

    public RbacResourceRpcProviderImpl(ResourceService resourceService,
                                       RbacDbReader dbReader) {
        this.resourceService = resourceService;
        this.dbReader = dbReader;
    }

    @Override
    public void create(String categoryId, ResourceRequest request) {
        this.resourceService.dispatch(CreateResourceCommand.create(categoryId,
                request.getCode(), request.getName(), request.getData(),
                request.getDataType(),request.getParentId()));
    }

    @Override
    public void update(String categoryId, String id, ResourceRequest request) {
        this.resourceService.dispatch(UpdateResourceCommand.create(id, categoryId,
                request.getCode(), request.getName(), request.getData(),
                request.getDataType(),
                request.getParentId()));
    }

    @Override
    public void delete(String categoryId, String id) {
        this.resourceService.dispatch(DeleteResourceCommand.create(id, categoryId));
    }

    @Override
    public Collection<ResourceGetResponse> getAll(String categoryId) {
        Collection<ResourceDto> resources = this.dbReader.getAllTreeResources(categoryId);

        Collection<ResourceGetResponse> rootResourceGetResponses =
                resources.stream().map(ii -> ResourceGetResponse.create(ii.getId(), ii.getCategoryId(),
                                ii.getName(), ii.getData(), ii.getDataType(), ii.getMetaId(), ii.getMetaConfig(), ii.getMetaData(),
                                ii.getCreator(), ii.getLastModifier()))
                        .collect(Collectors.toList());
        rootResourceGetResponses.forEach(ii -> {
            buildResource(ii, resources.stream().filter(ix -> ix.getId().equals(ii.getId())).findFirst().get());
        });

        return rootResourceGetResponses;
    }

    private static void buildResource(ResourceGetResponse resourceGetResponse, ResourceDto resourceDto) {
        if (resourceDto.getChildren() == null) {
            return;
        }

        resourceDto.getChildren().forEach(rc -> {
            ResourceGetResponse newResource = ResourceGetResponse.create(rc.getId(),
                    rc.getCategoryId(), rc.getName(), rc.getData(), rc.getDataType(), rc.getMetaId(), rc.getMetaConfig(),
                    rc.getMetaData(), rc.getCreator(), rc.getLastModifier());
            buildResource(newResource, rc);

            resourceGetResponse.assignChildResource(newResource);
        });
    }
}
