package com.bcxin.rbac.apis;

import com.bcxin.Infrastructures.InitConfig;
import com.bcxin.rbac.domain.DomainConfig;
import com.bcxin.rbac.domain.repository.RbacConfig;
import com.bcxin.registration.nacos.NacosDataSourceConfig;
import org.apache.dubbo.config.spring.context.annotation.EnableDubbo;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@EnableConfigurationProperties(NacosDataSourceConfig.class)
@Configuration
@EnableDubbo(scanBasePackages = {"com.bcxin.rbac.apis.impls", "com.bcxin.rbac.apis.custom"})
@ComponentScan("com.bcxin.api.interfaces.identities")
@Import({InitConfig.class, DomainConfig.class, RbacConfig.class})
public class StartupConfig {

}

