package com.bcxin.tenant.open.dubbo.common.configs;
import com.bcxin.tenant.open.infrastructures.InjectResolver;
import com.bcxin.tenant.open.infrastructures.TenantContext;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.valueTypes.TrafficTagValueType;
import org.apache.dubbo.config.ProviderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;

@Configuration
public class CommonConfig implements BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(CommonConfig.class);
    @Bean
    public ProviderConfig providerConfig(DubboConfigProperty property) {
        ProviderConfig config = new ProviderConfig();
        config.setVersion(property.getVersion());
        return config;
    }

    @Bean
    public JsonProvider jsonProvider() {
        return new JsonProvider.DefaultJsonProvider();
    }

    @Bean
    public TrafficTagValueType trafficTagValueType(@Value("${dubbo.provider.tag:null}") String tagLabel) {
        Collection<String> tags = new ArrayList<>();
        if (StringUtils.hasLength(tagLabel)) {
            tags = Arrays.stream(tagLabel.split(";")).filter(ii -> StringUtils.hasLength(ii))
                    .collect(Collectors.toList());
        }

        logger.error("当前的dubbo.provider.tag流量信息为:{}", tagLabel);

        return TrafficTagValueType.create(tags);
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        TenantContext.getInstance().setInjectResolver(new InjectResolver() {
            @Override
            public <T> T resolve(Class<T> tClass) {
                return beanFactory.getBean(tClass);
            }

            @Override
            public <T> Collection<T> resolveAll(Class<T> tClass) {
                return Collections.singleton(beanFactory.getBean(tClass));
            }
        });
    }
}
