package com.bcxin.tenant.open.domains.utils;

import com.bcxin.tenant.open.domains.entities.ConfigOfBillEntity;
import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import com.bcxin.tenant.open.infrastructures.enums.PointChangeType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.NotSupportTenantException;

import java.sql.Timestamp;
import java.util.Map;

/**
 * 联动值的计算方式
 */
public class PointUtils {
    public static int translate2Points(ConfigOfBillEntity config,CommunicatedType communicatedType,int minutes) {
        switch (communicatedType) {
            case Audio -> {
                return translate2Points(config, PointChangeType.AudioCost, minutes);
            }
            case Video -> {
                return translate2Points(config, PointChangeType.VideoCost, minutes);
            }
        }

        throw new NotSupportTenantException(String.format("暂不支持该沟通类型:%s", communicatedType));
    }

    public static int translate2Points(
            ConfigOfBillEntity config,
                                       PointChangeType changeType,
                                       Timestamp beginTime, Timestamp endTime) {
        int minutes = translate2DispatchTimeInMinutes(beginTime, endTime);

        /**
         * 未接听按照1个联动值来计算 B202401044120
         */
        if (endTime == null) {
            return 0 - 1;
        }

        return translate2Points(config, changeType, minutes);
    }

    public static int translate2DispatchTimeInMinutes(Timestamp beginTime, Timestamp endTime) {
        long seconds = 0;
        if (endTime == null) {
            /**
             * 结束时间为空, 按照1分钟进行计算; 未接听记录
             */
            seconds = 1;
        } else {
            seconds = (endTime.getTime() - beginTime.getTime()) / 1000;
        }


        /**
         * 直接忽略服务端中腾讯的时间与我们服务器的误差问题（有时候会出现用户的创建时间（入会议）会小于腾讯回调的时间）
         */
        if (seconds < 0) {
            seconds = Math.abs(seconds);
            //throw new BadTenantException(String.format("无效调度数据(beginTime=%s;endTime=%s)", beginTime, endTime));
        }

        int minutes = (int) Math.ceil(seconds * 1.0 / 60);

        /**
         * 不足一分钟算1分钟
         */
        if (minutes == 0) {
            return 1;
        }

        return minutes;
    }

    /**
     * 联动值计算
     * 音视频
     * 有视频的话; 那么只是视频则只计算视频的钱 * 2倍(因为双方都要收钱; 但是只收被调用方的钱)
     * 如果是非视频调度; 那么只计算音频 * 2倍(因为双方都要收钱; 但是只收被调用方的钱)
     * @param changeType
     * @param minutes
     * @return
     */
    private static int translate2Points(
            ConfigOfBillEntity config,
            PointChangeType changeType,int minutes) {

        int audioValue = 2;
        int videoValue = 4;
        if(config!=null) {
            audioValue = config.getAudioMinutePerson() == null ? 2 : config.getAudioMinutePerson().intValue();
            videoValue = config.getVideoMinutePerson() == null ? 4 : config.getVideoMinutePerson().intValue();
        }

        switch (changeType) {
            case AudioCost -> {
                return 0 - minutes * 1 * audioValue;
            }
            case VideoCost -> {
                return 0 - minutes * 1 * videoValue;
            }
        }

        throw new NotSupportTenantException(String.format("暂不支持该沟通类型:%s", changeType));
    }
}
