package com.bcxin.tenant.open.domains.services.impls;

import com.bcxin.tenant.open.domains.dtos.LogoSettingDTO;
import com.bcxin.tenant.open.domains.dtos.ReadInstructionSettingDTO;
import com.bcxin.tenant.open.domains.dtos.SosSettingDTO;
import com.bcxin.tenant.open.domains.repositories.TenantAccountRepository;
import com.bcxin.tenant.open.domains.services.TenantAccountService;
import com.bcxin.tenant.open.domains.services.commands.CreateLogoSettingCommand;
import com.bcxin.tenant.open.domains.services.commands.CreateReadOperationInstructionCommand;
import com.bcxin.tenant.open.domains.services.commands.CreateTenantAccountCommand;
import com.bcxin.tenant.open.infrastructures.components.IdWorker;
import org.springframework.stereotype.Service;

@Service
public class TenantAccountServiceImpl implements TenantAccountService {
    private final TenantAccountRepository tenantAccountRepository;
    private final IdWorker idWorker;

    public TenantAccountServiceImpl(TenantAccountRepository tenantAccountRepository, IdWorker idWorker) {
        this.tenantAccountRepository = tenantAccountRepository;
        this.idWorker = idWorker;
    }

    @Override
    public void dispatch(CreateTenantAccountCommand command) {
        command.validate();

        SosSettingDTO sosUpsetDTO = SosSettingDTO.create(
                command.getDeviceNo(), command.getAccountType(), command.getSosEnabled(),
                command.getSosKey(), command.getCreatorId(), command.getCreatorName());

        tenantAccountRepository.SosSetting(sosUpsetDTO);
    }

    @Override
    public void dispatch(CreateLogoSettingCommand command) {
        command.validate();

        LogoSettingDTO logoSettingDTO = LogoSettingDTO.create(command.getDeviceNo(),
                command.getDeviceType(),
                command.getLogo(),
                command.getTitle(),
                command.getOperatorId(),
                command.getOperatorName(),
                command.getAlarmBell());

        tenantAccountRepository.LogoSetting(logoSettingDTO);
    }

    @Override
    public void dispatch(CreateReadOperationInstructionCommand command) {
        command.validate();

        ReadInstructionSettingDTO settingDTO = ReadInstructionSettingDTO.create(
                command.getDeviceNo(), command.getAccountType(), command.getCreatorId(), command.getCreatorName());

        tenantAccountRepository.UpdateReadOperationInstructionStatus(settingDTO);
    }
}
