package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import lombok.Getter;

@Getter
public class UpdateProjectRoadmapCommand extends CommandAbstract {
    private final Long id;
    private final String name;
    private final Object roadmapImage;
    private final String projectId;
    private final Object roadmap;
    private final String operatorId;

    public UpdateProjectRoadmapCommand(Long id, String name, Object roadmapImage, String projectId, Object roadmap, String operatorId) {
        this.id = id;
        this.name = name;
        this.roadmapImage = roadmapImage;
        this.projectId = projectId;
        this.roadmap = roadmap;
        this.operatorId = operatorId;
    }


    public static UpdateProjectRoadmapCommand create(Long id, String name, Object roadmapImage, String projectId, Object roadmap, String operatorId) {
        return new UpdateProjectRoadmapCommand(id, name, roadmapImage, projectId, roadmap, operatorId);
    }
}
