package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import lombok.Getter;

import java.util.Collection;

/**
 * 发起调度的时候； 系统Kafka那边会调用该command进行操作
 */
@Getter
public class RollCallBatchDispatchCommand extends CommandAbstract {
    private final Collection<RollCallBatchDispatchCommandItem> items;

    public RollCallBatchDispatchCommand(Collection<RollCallBatchDispatchCommandItem> items) {
        this.items = items;
    }

    public static RollCallBatchDispatchCommand create(Collection<RollCallBatchDispatchCommandItem> items) {
        return new RollCallBatchDispatchCommand(items);
    }

    @Getter
    public static class RollCallBatchDispatchCommandItem extends CommandAbstract
    {
        private final Long rollCallId;
        private final Collection<String> employeeIds;
        private final String roomId;

        public RollCallBatchDispatchCommandItem(Long rollCallId, Collection<String> employeeIds, String roomId) {
            this.rollCallId = rollCallId;
            this.employeeIds = employeeIds;
            this.roomId = roomId;
        }

        public static RollCallBatchDispatchCommandItem create(Long rollCallId, Collection<String> employeeIds, String roomId) {
            return new RollCallBatchDispatchCommandItem(rollCallId, employeeIds, roomId);
        }
    }
}
