package com.bcxin.tenant.open.domains.services.commands;

import lombok.Getter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.Optional;

@Getter
public class InviteRoomUserCommandResponse {
    private final Long roomNo;
    private final Collection<InviteUsersCommandResponseItem> roomItems;

    public InviteRoomUserCommandResponse(Long roomNo,
                                         Collection<InviteUsersCommandResponseItem> roomItems) {
        this.roomNo = roomNo;
        this.roomItems = roomItems;
    }

    public static InviteRoomUserCommandResponse create(Long roomNo,
                                                       Collection<InviteUsersCommandResponseItem> roomItems) {
        return new InviteRoomUserCommandResponse(roomNo, roomItems);
    }

    public String getCid(String employeeId) {
        if (!StringUtils.hasLength(employeeId)) {
            return null;
        }

        if (CollectionUtils.isEmpty(this.getRoomItems())) {
            return null;
        }

        Optional<InviteUsersCommandResponseItem>
                roomCommandItemOptional =
                this.getRoomItems().stream()
                        .filter(ii -> ii.getEmployeeId().equalsIgnoreCase(employeeId))
                        .findFirst();

        if (roomCommandItemOptional.isPresent()) {
            return roomCommandItemOptional.get().getCid();
        }

        return null;
    }

    public String getEmployeeName(String employeeId) {
        if (!StringUtils.hasLength(employeeId)) {
            return null;
        }

        if (CollectionUtils.isEmpty(this.getRoomItems())) {
            return null;
        }

        Optional<InviteUsersCommandResponseItem>
                roomCommandItemOptional =
                this.getRoomItems().stream()
                        .filter(ii -> ii.getEmployeeId().equals(employeeId))
                        .findFirst();

        if (roomCommandItemOptional.isPresent()) {
            return roomCommandItemOptional.get().getEmployeeName();
        }

        return null;
    }


    @Getter
    public static class InviteUsersCommandResponseItem {
        private final String employeeId;
        private final String employeeName;
        private final String tenantUserId;
        private final String cid;

        public InviteUsersCommandResponseItem(String employeeId, String employeeName, String tenantUserId, String cid) {
            this.employeeId = employeeId;
            this.employeeName = employeeName;
            this.tenantUserId = tenantUserId;
            this.cid = cid;
        }

        public static InviteUsersCommandResponseItem create(String employeeId, String employeeName, String tenantUserId, String cid) {
            return new InviteUsersCommandResponseItem(employeeId, employeeName, tenantUserId, cid);
        }
    }
}
