package com.bcxin.tenant.open.domains.services.commands;
import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ResourceType;
import lombok.Getter;

import java.util.Set;

@Getter
public class CreateSsoPoliceIncidentsCommand extends CommandAbstract {
    private final String tenantUserId;
    private final String tenantEmployeeId;
    private final String organizationId;
    private final String securityStationId;

    private final String projectId;
    private final String projectName;
    private final String superviseDepartId;
    private final String securityStationName;
    private final double latitude;
    private final double longitude;
    private final String address;

    private final String superviseDepartName;
    private final String tenantUserName;
    private final String tenantUserIdCard;

    private final String stationAddress;

    private final String organizationName;

    private final Set<ResourceType> resourceTypes;

    public CreateSsoPoliceIncidentsCommand(String tenantUserId, String tenantEmployeeId, String organizationId,
                                           String organizationName,
                                           String projectId,
                                           String projectName,
                                           String securityStationId,
                                           String superviseDepartId,
                                           String securityStationName,
                                           String stationAddress,
                                           double latitude, double longitude,
                                           String address,
                                           String superviseDepartName,
                                           String tenantUserName,
                                           String tenantUserIdCard,
                                           Set<ResourceType> resourceTypes) {
        this.tenantUserId = tenantUserId;
        this.tenantEmployeeId = tenantEmployeeId;
        this.organizationId = organizationId;
        this.securityStationId = securityStationId;
        this.superviseDepartId = superviseDepartId;
        this.securityStationName = securityStationName;
        this.latitude = latitude;
        this.longitude = longitude;
        this.address = address;
        this.superviseDepartName = superviseDepartName;
        this.tenantUserName = tenantUserName;
        this.tenantUserIdCard = tenantUserIdCard;
        this.stationAddress = stationAddress;
        this.organizationName = organizationName;
        this.resourceTypes = resourceTypes;
        this.projectId = projectId;
        this.projectName = projectName;
    }

    public static CreateSsoPoliceIncidentsCommand create(String tenantUserId, String tenantEmployeeId, String organizationId,
                                                         String organizationName,
                                                         String projectId,
                                                         String projectName,
                                                         String securityStationId,
                                                         String superviseDepartId,
                                                         String securityStationName,
                                                         String stationAddress,
                                                         double latitude,
                                                         double longitude,
                                                         String address,
                                                         String superviseDepartName,
                                                         String tenantUserName,
                                                         String tenantUserIdCard,
                                                         Set<ResourceType> resourceTypes) {
        return new CreateSsoPoliceIncidentsCommand(
                tenantUserId, tenantEmployeeId, organizationId,organizationName,
                projectId,
                projectName,
                securityStationId, superviseDepartId,
                securityStationName,stationAddress, latitude, longitude,
                address, superviseDepartName, tenantUserName, tenantUserIdCard,resourceTypes
        );
    }
}
