package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RepetitiveRule;
import lombok.Getter;

import java.sql.Time;
import java.util.Collection;
import java.util.Date;

@Getter
public class CreateRollCallPlanCommand extends CommandAbstract {
    private final String name;
    private final Date beginDate;
    private final Date endDate;
    private final Collection<RepetitiveRule> repetitiveRules;
    private final String superviseDepartId;
    private final String superviseDepartName;
    private final Collection<String> stationTypes;
    private final Collection<Time> timers;

    public CreateRollCallPlanCommand(String name, Date beginDate, Date endDate,
                                     Collection<RepetitiveRule> repetitiveRules,
                                     String superviseDepartId, String superviseDepartName,
                                     Collection<String> stationTypes, Collection<Time> timers) {
        this.name = name;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.repetitiveRules = repetitiveRules;
        this.superviseDepartId = superviseDepartId;
        this.superviseDepartName = superviseDepartName;
        this.stationTypes = stationTypes;
        this.timers = timers;
    }

    public static CreateRollCallPlanCommand create(String name, Date beginDate, Date endDate,
                                                   Collection<RepetitiveRule> repetitiveRules,
                                                   String superviseDepartId, String superviseDepartName,
                                                   Collection<String> stationTypes, Collection<Time> timers) {
        return new CreateRollCallPlanCommand(name, beginDate, endDate,
                repetitiveRules, superviseDepartId, superviseDepartName,
                stationTypes, timers);
    }
}
