package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RailRuleType;
import com.bcxin.tenant.open.infrastructures.enums.RailShapeType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.bcxin.tenant.open.infrastructures.valueTypes.RdSecurityStationRailSnapshootValueType;
import lombok.Getter;
import org.apache.commons.collections.CollectionUtils;

import java.util.Date;

@Getter
public class CreateRdSecurityStationRailCommand extends CommandAbstract {
    private final String name;

    private final RailShapeType shapeType;

    private final RdSecurityStationRailSnapshootValueType.ShapedLocationValueType shapedLocation;

    private final String stationId;

    private final boolean fromStationManagement;
    private final String stationName;
    private final String superviseDepartId;
    private final String superviseDepartName;

    private final Date beginTime;

    private final Date endTime;

    private final RailRuleType ruleType;

    private final String note;
    private final String ownerOrganizationId;

    @Override
    public void validate() {
        super.validate();

        if (this.getShapeType() == null) {
            throw new BadTenantException("形状不能为空");
        }
        if (this.getRuleType() == null) {
            throw new BadTenantException("围栏类型不能为空");
        }

        if (this.getShapeType() != RailShapeType.Circle) {
            if (CollectionUtils.isEmpty(this.getShapedLocation().getGeos()) || this.getShapedLocation().getGeos().size() < 3) {
                throw new BadTenantException("无效电子围栏坐标参数(如果电子围栏的形状是非圆形, 那么必须提供不少于三个坐标)");
            }
        }

        if (!StringUtil.isEmpty(this.getNote()) && this.getNote().length() > 500) {
            throw new BadTenantException("电子围栏备注长度不能大于500字符");
        }

        if (this.isFromStationManagement()) {
            if (StringUtil.isEmpty(this.getStationName())) {
                throw new BadTenantException("驻勤点名称不能为空");
            }

            if (StringUtil.isEmpty(this.getSuperviseDepartId()) || StringUtil.isEmpty(this.getSuperviseDepartName())) {
                throw new BadTenantException("监管归属参数不能为空");
            }
        }
    }

    public CreateRdSecurityStationRailCommand(String name,
                                              RailShapeType shapeType,
                                              RdSecurityStationRailSnapshootValueType.ShapedLocationValueType shapedLocation,
                                              String stationId,
                                              boolean fromStationManagement,
                                              String stationName,
                                              String superviseDepartId,
                                              String superviseDepartName,
                                              Date beginTime,
                                              Date endTime,
                                              RailRuleType ruleType,
                                              String note,
                                              String ownerOrganizationId) {
        this.name = name;
        this.shapeType = shapeType;
        this.shapedLocation = shapedLocation;
        this.stationId = stationId;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.ruleType = ruleType;
        this.note = note;
        this.stationName = stationName;
        this.superviseDepartId = superviseDepartId;
        this.superviseDepartName = superviseDepartName;
        this.fromStationManagement = fromStationManagement;
        this.ownerOrganizationId = ownerOrganizationId;
    }

    public static CreateRdSecurityStationRailCommand create(String name,
                                                            RailShapeType shapeType,
                                                            RdSecurityStationRailSnapshootValueType.ShapedLocationValueType shapedLocation,
                                                            String stationId,
                                                            boolean fromStationManagement,
                                                            String stationName,
                                                            String superviseDepartId,
                                                            String superviseDepartName,
                                                            Date beginTime,
                                                            Date endTime,
                                                            RailRuleType ruleType,
                                                            String note,
                                                            String ownerOrganizationId) {
        return new CreateRdSecurityStationRailCommand(name,
                shapeType, shapedLocation,
                stationId,
                fromStationManagement,
                stationName,
                superviseDepartId,
                superviseDepartName,
                beginTime, endTime, ruleType, note,ownerOrganizationId);
    }
}
