package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DispatchAccountType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import lombok.Data;

@Data
public class CreateLogoSettingCommand extends CommandAbstract {

    private final String logo;
    private final String title;
    private final String deviceNo;
    private final DispatchAccountType deviceType;
    private final String operatorId;
    private final String operatorName;

    private final String alarmBell;


    public CreateLogoSettingCommand(String logo,
                                    String title,
                                    String deviceNo,
                                    DispatchAccountType deviceType,
                                    String operatorId, String operatorName,
                                    String alarmBell) {
        this.logo = logo;
        this.title = title;
        this.deviceType = deviceType;
        this.operatorId = operatorId;
        this.operatorName = operatorName;
        this.deviceNo = deviceNo;
        this.alarmBell = alarmBell;
    }

    @Override
    public void validate() {
        super.validate();

        if (this.getTitle() == null) {
            throw new BadTenantException("系统名称不能为空");
        }

    }

    public static CreateLogoSettingCommand create(
            String logo,
            String title,
            String deviceNo,
            DispatchAccountType deviceType,
            String operatorId, String operatorName,
            String alarmBell
    ) {
        CreateLogoSettingCommand command =
                new CreateLogoSettingCommand(
                logo,
                title,
                deviceNo,
                deviceType, operatorId, operatorName,alarmBell);
        return command;
    }
}
