package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DutySignInType;
import com.bcxin.tenant.open.infrastructures.enums.EmployeeSyncType;
import lombok.Data;
import lombok.Getter;

@Getter
public class CreateEmployeeSyncCommand extends CommandAbstract {
    private final EmployeeSyncType syncType;
    private final Object data;

    public CreateEmployeeSyncCommand(EmployeeSyncType syncType, Object data) {
        this.syncType = syncType;
        this.data = data;
    }

    public static CreateEmployeeSyncCommand create(EmployeeSyncType syncType, Object data) {
        return new CreateEmployeeSyncCommand(syncType, data);
    }

    public static class SyncChangedEventCommandAbstract extends CommandAbstract {
    }

    @Data
    public static class SecurityStationExpiredSyncCommand extends SyncChangedEventCommandAbstract {
        private String stationId;
    }

    @Data
    public static class OrgPurseChangedEventCommand extends SyncChangedEventCommandAbstract {
        private String organizationId;
        private Long points;
    }

    @Data
    public static class DeviceBoundChangedEventCommand extends SyncChangedEventCommandAbstract {
        private String employeeId;
        private String deviceNumber;
    }

    @Data
    public static class DutyStatusChangedEventCommand extends SyncChangedEventCommandAbstract {
        private String employeeId;
        private DutySignInType dutySignInType;
    }
}
