package com.bcxin.tenant.open.domains.repositories;

import com.bcxin.tenant.open.domains.dtos.ProcessTencentCallbackLogDTO;
import com.bcxin.tenant.open.domains.entities.TencentCallbackLogEntity;
import com.bcxin.tenant.open.domains.views.TencentCallbackLogView;
import com.bcxin.tenant.open.infrastructures.enums.ProcessedStatus;
import com.bcxin.tenant.open.infrastructures.repositories.RepositoryBase;

import java.util.Collection;

public interface TencentCallbackLogRepository extends RepositoryBase<TencentCallbackLogEntity> {
    void batchInsert(Collection<TencentCallbackLogEntity> logs);

    Collection<String> getTopExitRoomButPendingIds(Collection<Long> exitRoomLogIds);

    Collection<TencentCallbackLogView> getAllPendingLogsByRoomIds(Collection<Long> roomIds);

    void process(ProcessTencentCallbackLogDTO callbackLogDTO);


}
