package com.bcxin.tenant.open.domains.repositories;

import com.bcxin.tenant.open.domains.dtos.UpdateEmployeeLocationDTO;
import com.bcxin.tenant.open.domains.entities.RdEmployeeEntity;
import com.bcxin.tenant.open.infrastructures.repositories.RepositoryBase;

import java.util.Collection;

public interface RdEmployeeRepository extends RepositoryBase<RdEmployeeEntity> {
    Collection<RdEmployeeEntity> getByPage(Collection<String> ids, int pageIndex, int pageSize);

    void batchUpdate(Collection<RdEmployeeEntity> employees);

    void resetExpiredStationIdByIds(Collection<String> ids);

    RdEmployeeEntity getByNoPkId(String id);

    Collection<RdEmployeeEntity> getAllByNoPkIds(Collection<String> ids);

    Collection<String> getCheckingEmployeeIds(int pageIndex, int pageSize);

    RdEmployeeEntity getByTenantEmployeeId(String employeeId);

    Collection<String> getNonUsedRecords(int pageSize);

    int deleteNonUsedRecords(Collection<String> ids);

    void batchUpdateLocations(Collection<UpdateEmployeeLocationDTO> data);
}
