package com.bcxin.tenant.open.domains.repositories;

import com.bcxin.tenant.open.domains.entities.DailyBillEntity;
import com.bcxin.tenant.open.domains.pojo.DailyBillPojo;
import com.bcxin.tenant.open.domains.pojo.MonthBillPojo;
import com.bcxin.tenant.open.infrastructures.enums.BillType;
import com.bcxin.tenant.open.infrastructures.repositories.RepositoryBase;

import java.util.Date;
import java.util.List;

public interface DailyBillRepository extends RepositoryBase<DailyBillEntity> {
    void insert(List<DailyBillEntity> dailyBillEntityList);

    List<MonthBillPojo> calcMonthBill(String date, BillType type);

    List<DailyBillPojo> getAttendanceBillInfo(String orgId, Date fromDate, Date endDate);

    List<DailyBillPojo> getRollCallBillInfo(String orgId, Date fromDate, Date endDate);

    List<DailyBillPojo> getEmployeeLocationBillInfo(String orgId, Date fromDate, Date endDate);

    List<DailyBillPojo> getSecurityStationRailBillInfo(String orgId, Date fromDate, Date endDate);

    List<MonthBillPojo> calcMonthBillRange(String orgId, BillType type, Date fromDate, Date endDate);
}
