package com.bcxin.tenant.open.domains.exceptions;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import lombok.Getter;

import java.util.ArrayList;
import java.util.Collection;

@Getter
public class GeTuiBadTenantException extends BadTenantException {

    private final Collection<GeTuiBadDataItem> dataItems;

    public GeTuiBadTenantException(Collection<GeTuiBadDataItem> dataItems) {
        super("个推调用异常");
        if (dataItems == null) {
            this.dataItems = new ArrayList<>();
        } else {
            this.dataItems = dataItems;
        }
    }

    @Getter
    public static class GeTuiBadDataItem {
        private final String referenceNumber;
        private final Collection<String> cIds;
        private final String message;


        public GeTuiBadDataItem(String referenceNumber, Collection<String> cIds, String message) {
            this.referenceNumber = referenceNumber;
            this.cIds = cIds;
            this.message = message;
        }

        public static GeTuiBadDataItem create(String referenceNumber, Collection<String> cIds, String message) {
            return new GeTuiBadDataItem(referenceNumber, cIds, message);
        }
    }
}
