package com.bcxin.tenant.open.domains.events;

import lombok.Getter;
import org.springframework.context.ApplicationEvent;

@Getter
public class CompanyNameChangedEvent extends ApplicationEvent {
    private final String organizationId;

    public CompanyNameChangedEvent(String organizationId) {
        super(organizationId);
        this.organizationId = organizationId;
    }

    public static CompanyNameChangedEvent create(String organizationId) {
        return new CompanyNameChangedEvent(organizationId);
    }
}
