package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.UserPurseTransactionType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;
import java.time.Instant;

/**
 * 用户钱包交易明细信息
 */
@TableName(value = "user_purse_transactions",autoResultMap = true)
@Data
public class UserPurseTransactionEntity extends EntityAbstract {
    @TableId("id")
    private Long id;

    @TableField(value = "reference_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private UserPurseTransactionType referenceType;

    @TableField("reference_number")
    private String referenceNumber;

    @TableField("note")
    private String note;

    @TableField("points")
    private long points;

    @TableField("user_purse_id")
    private String userPurseId;

    @TableField("created_time")
    private Timestamp createdTime;

    public UserPurseTransactionEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static UserPurseTransactionEntity create(UserPurseTransactionType referenceType,
                                                    String referenceNumber,
                                                    String note,
                                                    long points,
                                                    String userPurseId){
        UserPurseTransactionEntity entity = new UserPurseTransactionEntity();
        entity.setReferenceType(referenceType);
        entity.setReferenceNumber(referenceNumber);
        entity.setNote(note);
        entity.setPoints(points);
        entity.setUserPurseId(userPurseId);

        return entity;
    }
}
