package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.enums.ContentType;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ProcessedStatus;
import lombok.Data;

import java.sql.Timestamp;
import java.time.Instant;


/**
 *
 */
@TableName(value = "tenant_warn_contents")
@Data
public class TenantWarnContentEntity extends EntityAbstract implements Aggregate {
    @TableField(value = "id")
    private Long id;

    @TableField(value = "content_type")
    private ContentType contentType;

    @TableField(value = "reference_number")
    private String referenceNumber;

    @TableField(value = "content")
    private String content;

    @TableField(value = "created_time")
    private Timestamp createdTime;

    @TableField(value = "processed_status")
    private ProcessedStatus processedStatus;

    @TableField(value = "last_processed_result")
    private String lastProcessedResult;

    @TableField(value = "last_processed_time")
    private Timestamp lastProcessedTime;

    @TableField(value = "counter")
    private Long counter;

    public TenantWarnContentEntity() {
        this.setProcessedStatus(ProcessedStatus.Init);
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setCounter(1l);
    }

    public static TenantWarnContentEntity create(ContentType contentType,
                                                 String referenceNumber,
                                                 String content
                                                 ) {
        TenantWarnContentEntity contentEntity = new TenantWarnContentEntity();
        contentEntity.setContentType(contentType);
        contentEntity.setContent(content);
        contentEntity.setReferenceNumber(referenceNumber);

        return contentEntity;
    }
}
