package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ContentFollowType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;
import java.time.Instant;

@TableName(value = "tenant_content_follows",autoResultMap = true)
@Data
public class TenantContentFollowEntity extends EntityAbstract implements Aggregate {
    @TableField(value = "id")
    private Long id;

    /**
     * 关注的类型
     */
    @TableField(value = "follow_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private ContentFollowType followType;

    /**
     * 关注的内容Id
     */
    @TableField(value = "content_follow_id")
    private String contentFollowId;

    /**
     * 是否关注
     */
    @TableField(value = "is_followed")
    private boolean followed;

    /**
     * 关注时间
     */
    @TableField(value = "followed_time")
    private Timestamp followedTime;

    /**
     * 取消关注时间
     */
    @TableField(value = "unfollowed_time")
    private Timestamp unfollowedTime;

    /**
     * 设备编号; 一般为调度台
     */
    @TableField(value = "device_no")
    private String deviceNo;

    /**
     * 关注者的拥有者: owner_id
     */
    @TableField(value = "follow_user_id")
    private String followUserId;

    @TableField(value = "unfollow_user_id")
    private String unfollowUserId;

    @TableField(value = "created_time")
    private Timestamp createdTime;

    public TenantContentFollowEntity()
    {
        Timestamp now = Timestamp.from(Instant.now());

        this.setCreatedTime(now);
    }

    public void markFollowed(String deviceNo,String userId) {
        this.setFollowed(true);

        this.setFollowedTime(Timestamp.from(Instant.now()));
        this.setDeviceNo(deviceNo);
        this.setFollowUserId(userId);
    }

    public void markUnfollowed(String userId) {
        this.setFollowed(false);
        this.setUnfollowUserId(userId);
    }


    public static TenantContentFollowEntity create(Long id, ContentFollowType followType,
                                                   String contentFollowId,
                                                   String deviceNo,
                                                   String followUserId) {
        TenantContentFollowEntity contentFollow = new TenantContentFollowEntity();
        contentFollow.setId(id);
        contentFollow.setFollowType(followType);
        contentFollow.setContentFollowId(contentFollowId);
        contentFollow.markFollowed(deviceNo, followUserId);

        return contentFollow;
    }
}
