package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ReferenceType;
import lombok.Data;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;

/**
 * 驻勤、岗点、巡防工作点
 */
@TableName(value = "rd_work_stations",autoResultMap = true)
@Data
public class RdWorkstationEntity extends EntityAbstract implements Aggregate {

    @TableField("id")
    private Long id;

    /**
     * 经纬度
     */
    @TableField(value = "lon_lat")
    private String lonLat;

    /**
     * 顺序
     */
    @TableField(value = "display_order")
    private int displayOrder;

    /**
     * 显示名: 驻勤点、岗点、巡防任务-点位
     */
    @TableField(value = "display_name")
    private String displayName;

    /**
     * 最后同步时间
     */
    @TableField(value = "last_sync_time")
    private Timestamp lastSyncTime;

    @TableField(value = "address")
    private String address;

    /**
     * 执行范围
     */
    @TableField(value = "perform_range")
    private String performRange;

    /**
     * 因为类型: 驻勤点, 岗点, 点位
     */
    @TableField(value = "reference_type", jdbcType = JdbcType.TINYINT, javaType = true, typeHandler = EnumOrdinalTypeHandler.class)
    private ReferenceType referenceType;

    /**
     * 驻勤点/岗点Id或者任务Id
     */
    @TableField(value = "reference_number")
    private String referenceNumber;

    /**
     * 任务对应的线路Id
     */
    @TableField(value = "reference_line_id")
    private String referenceLineId;

    /**
     * 任务对应的线路对应的点Id
     */
    @TableField(value = "reference_point_id")
    private String referencePointId;

    /**
     * 所属的监管归属
     */
    @TableField(value = "supervise_depart_id")
    private String superviseDepartId;
}
